/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.kafka.common.converter.ConversionException;
import com.networknt.kafka.common.converter.SchemaConverter;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.NoWrappingJsonEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroNoWrappingConverter
implements SchemaConverter {
    private static final Logger log = LoggerFactory.getLogger(AvroNoWrappingConverter.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Override
    public SchemaConverter.JsonNodeAndSize toJson(Object value) {
        try {
            byte[] bytes = this.toJsonBytes(value);
            if (bytes == null) {
                return new SchemaConverter.JsonNodeAndSize(NullNode.getInstance(), 0L);
            }
            return new SchemaConverter.JsonNodeAndSize(JSON_MAPPER.readTree(bytes), bytes.length);
        }
        catch (IOException e) {
            log.error("Jackson failed to deserialize JSON generated by Avro's JSON encoder: ", e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception converting Avro to JSON: ", e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
    }

    private byte[] toJsonBytes(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Schema schema = AvroSchemaUtils.getSchema(value);
            NoWrappingJsonEncoder encoder = new NoWrappingJsonEncoder(schema, (OutputStream)out, false);
            GenericDatumWriter<Object> writer = new GenericDatumWriter<Object>(schema);
            Object wrappedValue = value;
            if (value instanceof byte[]) {
                wrappedValue = ByteBuffer.wrap((byte[])value);
            }
            writer.write(wrappedValue, encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

