/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import com.networknt.config.Config;
import com.networknt.kafka.common.KafkaConsumerConfig;
import com.networknt.kafka.common.KafkaProducerConfig;
import com.networknt.kafka.common.KafkaStreamsConfig;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LightSchemaRegistryClient
extends CachedSchemaRegistryClient {
    private static final Map<String, Object> configs;
    private static final String url;
    private static Integer cache;

    public LightSchemaRegistryClient() {
        super(new RestService(Collections.singletonList(url)), (int)cache, Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider()), configs, null);
    }

    static {
        KafkaConsumerConfig consumerConfig;
        KafkaProducerConfig producerConfig;
        cache = 100;
        configs = new HashMap<String, Object>();
        KafkaStreamsConfig streamsConfig = (KafkaStreamsConfig)Config.getInstance().getJsonObjectConfig("kafka-streams", KafkaStreamsConfig.class);
        if (streamsConfig != null) {
            configs.putAll(streamsConfig.getProperties());
        }
        if (configs.size() == 0 && (producerConfig = (KafkaProducerConfig)Config.getInstance().getJsonObjectConfig("kafka-producer", KafkaProducerConfig.class)) != null) {
            configs.putAll(producerConfig.getProperties());
        }
        if (configs.size() == 0 && (consumerConfig = (KafkaConsumerConfig)Config.getInstance().getJsonObjectConfig("kafka-consumer", KafkaConsumerConfig.class)) != null) {
            configs.putAll(consumerConfig.getProperties());
        }
        url = (String)configs.get("schema.registry.url");
        Object cacheObj = configs.get("schema.registry.cache");
        if (cacheObj != null && cacheObj instanceof String) {
            cache = Integer.valueOf((String)cacheObj);
        }
    }
}

