/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class EventId
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -1405236215870335809L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"EventId\",\"namespace\":\"com.networknt.kafka.common\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"a unique identifier for the event\"},{\"name\":\"userId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the user who creates the event\"},{\"name\":\"hostId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the host which is the event is created\"},{\"name\":\"nonce\",\"type\":\"long\",\"doc\":\"the number of the transactions for the user\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"time the event is recorded\",\"default\":0},{\"name\":\"derived\",\"type\":\"boolean\",\"doc\":\"indicate if the event is derived from event processor\",\"default\":false}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<EventId> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<EventId> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String id;
    private String userId;
    private String hostId;
    private long nonce;
    private long timestamp;
    private boolean derived;
    private static final DatumWriter<EventId> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<EventId> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<EventId> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<EventId> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<EventId> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<EventId>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static EventId fromByteBuffer(ByteBuffer b) throws IOException {
        return (EventId)DECODER.decode(b);
    }

    public EventId() {
    }

    public EventId(String id, String userId, String hostId, Long nonce, Long timestamp, Boolean derived) {
        this.id = id;
        this.userId = userId;
        this.hostId = hostId;
        this.nonce = nonce;
        this.timestamp = timestamp;
        this.derived = derived;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.userId;
            }
            case 2: {
                return this.hostId;
            }
            case 3: {
                return this.nonce;
            }
            case 4: {
                return this.timestamp;
            }
            case 5: {
                return this.derived;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.userId = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.hostId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.nonce = (Long)value$;
                break;
            }
            case 4: {
                this.timestamp = (Long)value$;
                break;
            }
            case 5: {
                this.derived = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String value) {
        this.userId = value;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String value) {
        this.hostId = value;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long value) {
        this.nonce = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long value) {
        this.timestamp = value;
    }

    public boolean getDerived() {
        return this.derived;
    }

    public void setDerived(boolean value) {
        this.derived = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(EventId other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.userId);
        out.writeString(this.hostId);
        out.writeLong(this.nonce);
        out.writeLong(this.timestamp);
        out.writeBoolean(this.derived);
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.id = in.readString();
            this.userId = in.readString();
            this.hostId = in.readString();
            this.nonce = in.readLong();
            this.timestamp = in.readLong();
            this.derived = in.readBoolean();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.id = in.readString();
                        continue block8;
                    }
                    case 1: {
                        this.userId = in.readString();
                        continue block8;
                    }
                    case 2: {
                        this.hostId = in.readString();
                        continue block8;
                    }
                    case 3: {
                        this.nonce = in.readLong();
                        continue block8;
                    }
                    case 4: {
                        this.timestamp = in.readLong();
                        continue block8;
                    }
                    case 5: {
                        this.derived = in.readBoolean();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<EventId>
    implements RecordBuilder<EventId> {
        private String id;
        private String userId;
        private String hostId;
        private long nonce;
        private long timestamp;
        private boolean derived;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.id)) {
                this.id = this.data().deepCopy(this.fields()[0].schema(), other.id);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.userId)) {
                this.userId = this.data().deepCopy(this.fields()[1].schema(), other.userId);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.hostId)) {
                this.hostId = this.data().deepCopy(this.fields()[2].schema(), other.hostId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.nonce)) {
                this.nonce = this.data().deepCopy(this.fields()[3].schema(), other.nonce);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue(this.fields()[4], other.timestamp)) {
                this.timestamp = this.data().deepCopy(this.fields()[4].schema(), other.timestamp);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.derived)) {
                this.derived = this.data().deepCopy(this.fields()[5].schema(), other.derived);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(EventId other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.id)) {
                this.id = this.data().deepCopy(this.fields()[0].schema(), other.id);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.userId)) {
                this.userId = this.data().deepCopy(this.fields()[1].schema(), other.userId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.hostId)) {
                this.hostId = this.data().deepCopy(this.fields()[2].schema(), other.hostId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.nonce)) {
                this.nonce = this.data().deepCopy(this.fields()[3].schema(), other.nonce);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.timestamp)) {
                this.timestamp = this.data().deepCopy(this.fields()[4].schema(), other.timestamp);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.derived)) {
                this.derived = this.data().deepCopy(this.fields()[5].schema(), other.derived);
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[0], value);
            this.id = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getUserId() {
            return this.userId;
        }

        public Builder setUserId(String value) {
            this.validate(this.fields()[1], value);
            this.userId = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearUserId() {
            this.userId = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getHostId() {
            return this.hostId;
        }

        public Builder setHostId(String value) {
            this.validate(this.fields()[2], value);
            this.hostId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHostId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHostId() {
            this.hostId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public long getNonce() {
            return this.nonce;
        }

        public Builder setNonce(long value) {
            this.validate(this.fields()[3], value);
            this.nonce = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasNonce() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearNonce() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(long value) {
            this.validate(this.fields()[4], value);
            this.timestamp = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearTimestamp() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public boolean getDerived() {
            return this.derived;
        }

        public Builder setDerived(boolean value) {
            this.validate(this.fields()[5], value);
            this.derived = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDerived() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDerived() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        @Override
        public EventId build() {
            try {
                EventId record = new EventId();
                record.id = this.fieldSetFlags()[0] ? this.id : (String)this.defaultValue(this.fields()[0]);
                record.userId = this.fieldSetFlags()[1] ? this.userId : (String)this.defaultValue(this.fields()[1]);
                record.hostId = this.fieldSetFlags()[2] ? this.hostId : (String)this.defaultValue(this.fields()[2]);
                record.nonce = this.fieldSetFlags()[3] ? this.nonce : (Long)this.defaultValue(this.fields()[3]);
                record.timestamp = this.fieldSetFlags()[4] ? this.timestamp : (Long)this.defaultValue(this.fields()[4]);
                record.derived = this.fieldSetFlags()[5] ? this.derived : (Boolean)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

