/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.avro.io.NoWrappingJsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

public class AvroConverter {
    public static String toJson(SpecificRecord record, boolean pretty) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            NoWrappingJsonEncoder jsonEncoder = new NoWrappingJsonEncoder(record.getSchema(), (OutputStream)baos, pretty);
            SpecificDatumWriter writer = new SpecificDatumWriter(record.getSchema());
            writer.write(record, jsonEncoder);
            jsonEncoder.flush();
            baos.flush();
            byte[] bytes = baos.toByteArray();
            string = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        baos.close();
        return string;
    }
}

