/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.common;

import com.networknt.kafka.common.AbstractAvroSerDe;
import com.networknt.kafka.common.AvroSchemaUtils;
import com.networknt.kafka.common.NonRecordContainer;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvroSerializer
extends AbstractAvroSerDe {
    static final Logger logger = LoggerFactory.getLogger(AbstractAvroSerializer.class);
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    protected byte[] serializeImpl(Object object) {
        Schema schema = null;
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            schema = AvroSchemaUtils.getSchema(object);
            String subject = schema.getFullName();
            Boolean autoRegistry = (Boolean)this.config.get("schema.registry.auto.register.schemas");
            if (autoRegistry.booleanValue()) {
                restClientErrorMsg = "Error registering Avro schema: ";
                id = this.schemaRegistry.register(subject, new AvroSchema(schema));
            } else {
                restClientErrorMsg = "Error retrieving Avro schema: ";
                id = this.schemaRegistry.getId(subject, new AvroSchema(schema));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            if (object instanceof byte[]) {
                out.write((byte[])object);
            } else {
                BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(out, null);
                Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
                GenericDatumWriter writer = value instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(value, encoder);
                encoder.flush();
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Error serializing Avro message", e);
        }
        catch (RestClientException e) {
            throw new RuntimeException(restClientErrorMsg + String.valueOf(schema), e);
        }
    }
}

