/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import com.networknt.info.ServerInfoConfig;
import com.networknt.server.ServerConfig;
import com.networknt.utility.ConfigUtils;
import com.networknt.utility.FingerPrintUtil;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoUtil {
    static final Logger logger = LoggerFactory.getLogger(ServerInfoUtil.class);

    public static Map<String, Object> updateNormalizeKey(Map<String, Object> moduleRegistry, ServerInfoConfig config) {
        Map<String, Object> newModuleRegistry = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : moduleRegistry.entrySet()) {
            String key = entry.getKey();
            if (key.contains(":")) {
                key = key.substring(0, key.indexOf(":"));
            }
            newModuleRegistry.put(key, entry.getValue());
        }
        newModuleRegistry = ConfigUtils.normalizeMap(newModuleRegistry, config.getKeysToNotSort());
        return newModuleRegistry;
    }

    public static Map<String, Object> getDeployment() {
        LinkedHashMap<String, Object> deploymentMap = new LinkedHashMap<String, Object>();
        deploymentMap.put("apiVersion", Util.getJarVersion());
        deploymentMap.put("frameworkVersion", ServerInfoUtil.getFrameworkVersion());
        return deploymentMap;
    }

    public static Map<String, Object> getEnvironment() {
        LinkedHashMap<String, Object> envMap = new LinkedHashMap<String, Object>();
        envMap.put("host", ServerInfoUtil.getHost());
        envMap.put("runtime", ServerInfoUtil.getRuntime());
        envMap.put("system", ServerInfoUtil.getSystem());
        return envMap;
    }

    public static Map<String, Object> getRuntime() {
        LinkedHashMap<String, Object> runtimeMap = new LinkedHashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        runtimeMap.put("availableProcessors", runtime.availableProcessors());
        runtimeMap.put("freeMemory", runtime.freeMemory());
        runtimeMap.put("totalMemory", runtime.totalMemory());
        runtimeMap.put("maxMemory", runtime.maxMemory());
        return runtimeMap;
    }

    public static Map<String, Object> getSystem() {
        LinkedHashMap<String, Object> systemMap = new LinkedHashMap<String, Object>();
        Properties properties = System.getProperties();
        systemMap.put("javaVendor", properties.getProperty("java.vendor"));
        systemMap.put("javaVersion", properties.getProperty("java.version"));
        systemMap.put("osName", properties.getProperty("os.name"));
        systemMap.put("osVersion", properties.getProperty("os.version"));
        systemMap.put("userTimezone", properties.getProperty("user.timezone"));
        return systemMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFrameworkVersion() {
        String version = null;
        String path = "META-INF/maven/com.networknt/info/pom.properties";
        InputStream in = ClassLoader.getSystemResourceAsStream(path);
        try {
            Properties prop = new Properties();
            prop.load(in);
            version = prop.getProperty("version");
        }
        catch (Exception exception) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return version;
    }

    public static String getServerTlsFingerPrint() {
        String fingerPrint = null;
        ServerConfig serverConfig = ServerConfig.getInstance();
        String keystoreName = serverConfig.getKeystoreName();
        String keystorePass = serverConfig.getKeystorePass();
        if (keystoreName != null) {
            try (InputStream stream = Config.getInstance().getInputStreamFromFile(keystoreName);){
                KeyStore loadedKeystore = KeyStore.getInstance("JKS");
                loadedKeystore.load(stream, keystorePass.toCharArray());
                X509Certificate cert = (X509Certificate)loadedKeystore.getCertificate("server");
                if (cert != null) {
                    fingerPrint = FingerPrintUtil.getCertFingerPrint(cert);
                } else {
                    logger.error("Unable to find the certificate with alias name as server in the keystore");
                }
            }
            catch (Exception e) {
                logger.error("Unable to load server keystore ", e);
            }
        }
        return fingerPrint;
    }

    public static Map<String, Object> getHost() {
        LinkedHashMap<String, Object> hostMap = new LinkedHashMap<String, Object>();
        String ip = "unknown";
        String hostname = "unknown";
        InetAddress inetAddress = Util.getInetAddress();
        ip = inetAddress.getHostAddress();
        hostname = inetAddress.getHostName();
        hostMap.put("ip", ip);
        hostMap.put("hostname", hostname);
        return hostMap;
    }

    public static Map<String, Object> getSecurity() {
        LinkedHashMap<String, Object> secMap = new LinkedHashMap<String, Object>();
        secMap.put("serverFingerPrint", ServerInfoUtil.getServerTlsFingerPrint());
        return secMap;
    }

    public static Map<String, Object> getServerInfo(ServerInfoConfig config) {
        LinkedHashMap<String, Object> infoMap = new LinkedHashMap<String, Object>();
        infoMap.put("deployment", ServerInfoUtil.getDeployment());
        infoMap.put("environment", ServerInfoUtil.getEnvironment());
        infoMap.put("security", ServerInfoUtil.getSecurity());
        infoMap.put("component", ServerInfoUtil.updateNormalizeKey(ModuleRegistry.getModuleRegistry(), config));
        infoMap.put("plugin", ServerInfoUtil.updateNormalizeKey(ModuleRegistry.getPluginRegistry(), config));
        infoMap.put("plugins", ModuleRegistry.getPlugins());
        return infoMap;
    }
}

