/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.info.ServerInfoConfig;
import com.networknt.info.ServerInfoUtil;
import com.networknt.utility.ModuleRegistry;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoGetHandler
implements LightHttpHandler {
    static final String STATUS_SERVER_INFO_DISABLED = "ERR10013";
    static final Logger logger = LoggerFactory.getLogger(ServerInfoGetHandler.class);
    static ServerInfoConfig config;

    public ServerInfoGetHandler() {
        if (logger.isDebugEnabled()) {
            logger.debug("ServerInfoGetHandler is constructed");
        }
        config = ServerInfoConfig.load();
        ModuleRegistry.registerModule("info", ServerInfoConfig.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("info"), null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (config.isEnableServerInfo()) {
            Map<String, Object> infoMap = ServerInfoUtil.getServerInfo(config);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(infoMap));
        } else {
            this.setExchangeStatus(exchange, STATUS_SERVER_INFO_DISABLED, new Object[0]);
        }
    }
}

