/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.http;

import com.networknt.http.HttpStatus;
import com.networknt.http.ResponseEntity;
import com.networknt.utility.ObjectUtils;
import io.undertow.util.HeaderMap;

public class CachedResponseEntity<T>
extends ResponseEntity<T> {
    public Long timestamp = 0L;

    public CachedResponseEntity(HttpStatus status) {
        super(null, null, status);
        this.timestamp = System.currentTimeMillis();
    }

    public CachedResponseEntity(T body, HttpStatus status) {
        super(body, null, status);
        this.timestamp = System.currentTimeMillis();
    }

    public CachedResponseEntity(HeaderMap headers, HttpStatus status) {
        super(null, headers, status);
        this.timestamp = System.currentTimeMillis();
    }

    public CachedResponseEntity(T body, HeaderMap headers, HttpStatus status) {
        super(body, headers, status);
        this.timestamp = System.currentTimeMillis();
    }

    public CachedResponseEntity(T body, HeaderMap headers, int rawStatus) {
        super(body, headers, HttpStatus.valueOf(rawStatus));
        this.timestamp = System.currentTimeMillis();
    }

    public CachedResponseEntity(T body, HeaderMap headers, HttpStatus status, Long timestamp) {
        super(body, headers, status);
        this.timestamp = timestamp;
    }

    public CachedResponseEntity(T body, HeaderMap headers, int rawStatus, Long timestamp) {
        super(body, headers, rawStatus);
        this.timestamp = timestamp;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        CachedResponseEntity otherEntity = (CachedResponseEntity)other;
        return ObjectUtils.nullSafeEquals(this.timestamp, otherEntity.timestamp);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode(this.timestamp);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.timestamp.toString());
        builder.append(',');
        HttpStatus status = this.getStatusCode();
        if (status != null) {
            builder.append(status.toString());
            builder.append(',');
        }
        builder.append(',');
        Object body = this.getBody();
        HeaderMap headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append(headers);
        builder.append('>');
        return builder.toString();
    }
}

