/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="request-injection", configName="request-injection", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class RequestInjectionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RequestInjectionConfig.class);
    public static final String CONFIG_NAME = "request-injection";
    private static final String ENABLED = "enabled";
    private static final String APPLIED_BODY_INJECTION_PATH_PREFIXES = "appliedBodyInjectionPathPrefixes";
    private static final String MAX_BUFFERS = "maxBuffers";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", externalized=true, defaultValue=true, description="indicator of enabled")
    private boolean enabled;
    @ArrayField(configFieldName="appliedBodyInjectionPathPrefixes", externalizedKeyName="appliedBodyInjectionPathPrefixes", externalized=true, description="request body injection applied path prefixes. Injecting the request body and output into the audit log is very heavy operation,\nand it should only be enabled when necessary or for diagnose session to resolve issues. This list can be updated on the config\nserver or local values.yml, then an API call to the config-reload endpoint to apply the changes from light-portal control pane.\nPlease be aware that big request body will only log the beginning part of it in the audit log and gzip encoded request body can\nnot be injected. Even the body injection is not applied, you can still transform the request for headers, query parameters, path\nparameters etc. The format is a list of strings separated with commas or a JSON list in values.yml definition from config server,\nor you can use yaml format in this file or values.yaml on local filesystem. The following are the examples.\nrequest-injection.appliedBodyInjectionPathPrefixes: [\"/v1/cats\", \"/v1/dogs\"]\nrequest-injection.appliedBodyInjectionPathPrefixes: /v1/cats, /v1/dogs\nrequest-injection.appliedBodyInjectionPathPrefixes:\n  - /v1/cats\n  - /v1/dogs", items=String.class)
    private List<String> appliedBodyInjectionPathPrefixes;
    @IntegerField(configFieldName="maxBuffers", externalizedKeyName="maxBuffers", externalized=true, defaultValue=1024, description="Max number of buffers for the interceptor. The default value is 1024. If the number of buffers exceeds this value, the large\nrequest body will be truncated. The buffer size is 16K, so the max size of the body can be intercepted is 16M. If you want to\nupload large file to the server with ExternalServiceHandler, you might need to increase the number of buffers to a larger value.\nPlease be aware that the memory usage will be increased as well. So please use it with caution and test it with load test. Also,\nplease make sure that you update the server.maxTransferFileSize to a larger value that matches the maxBuffers * 1024.")
    private int maxBuffers;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    public RequestInjectionConfig() {
        this(CONFIG_NAME);
    }

    public RequestInjectionConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    static RequestInjectionConfig load() {
        return new RequestInjectionConfig();
    }

    static RequestInjectionConfig load(String configName) {
        return new RequestInjectionConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public List<String> getAppliedBodyInjectionPathPrefixes() {
        return this.appliedBodyInjectionPathPrefixes;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.getMappedConfig().get(MAX_BUFFERS)) != null) {
            this.maxBuffers = Config.loadIntegerValue(MAX_BUFFERS, object);
        }
    }

    private void setConfigList() {
        if (this.mappedConfig != null && this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES);
            this.appliedBodyInjectionPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.appliedBodyInjectionPathPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the appliedBodyInjectionPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.appliedBodyInjectionPathPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.appliedBodyInjectionPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("appliedBodyInjectionPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

