/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.httpstring.AttachmentConstants;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditAttachmentUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuditAttachmentUtil.class);

    public static void populateAuditAttachmentField(HttpServerExchange exchange, String fieldName, String fieldValue) {
        HashMap<String, String> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo == null) {
            logger.trace("AuditInfo is null, creating a new one and inserting the key-value pair '{}:{}'", (Object)fieldName, (Object)fieldValue);
            auditInfo = new HashMap<String, String>();
            auditInfo.put(fieldName, fieldValue);
        } else {
            logger.trace("AuditInfo is not null, inserting the key-value pair '{}:{}'", (Object)fieldName, (Object)fieldValue);
            if (auditInfo.containsKey(fieldName)) {
                logger.debug("AuditInfo already contains the field '{}'! Replacing the value '{}' with '{}'.", fieldName, auditInfo.get(fieldName), fieldValue);
            }
            auditInfo.put(fieldName, fieldValue);
        }
        exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
    }
}

