/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.correlation;

import com.networknt.config.Config;
import com.networknt.correlation.CorrelationConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.UuidUtil;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CorrelationHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(CorrelationHandler.class);
    public static CorrelationConfig config;
    private volatile HttpHandler next;

    public CorrelationHandler() {
        config = CorrelationConfig.load();
        logger.info("CorrelationHandler is loaded.");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        logger.debug("CorrelationHandler.handleRequest starts.");
        String tid = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
        if (tid != null) {
            exchange.getResponseHeaders().put(HttpStringConstants.TRACEABILITY_ID, tid);
            this.addHandlerMDCContext(exchange, config.getTraceabilityMdcField(), tid);
            MDC.put(config.getTraceabilityMdcField(), tid);
        } else if (MDC.get(CorrelationHandler.config.traceabilityMdcField) != null) {
            MDC.remove(config.getTraceabilityMdcField());
        }
        String cId = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID);
        if (cId == null && config.isAutogenCorrelationID()) {
            cId = UuidUtil.uuidToBase64(UuidUtil.getUUID());
            exchange.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, cId);
            String tId = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
            if (tId != null) {
                logger.info("Associate traceability Id {} with correlation Id {}", (Object)tId, (Object)cId);
            }
        }
        MDC.put(config.getCorrelationMdcField(), cId);
        if (cId != null) {
            this.addHandlerMDCContext(exchange, config.getCorrelationMdcField(), cId);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (HeaderValues header : exchange.getRequestHeaders()) {
                for (String value : header) {
                    sb.append(header.getHeaderName()).append("=").append(value).append("\n");
                }
            }
            logger.trace("Request Headers: '{}'", (Object)sb);
        }
        logger.debug("CorrelationHandler.handleRequest ends.");
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("correlation", CorrelationHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("correlation"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("correlation", CorrelationHandler.class.getName(), config.getMappedConfig(), null);
        logger.info("CorrelationHandler is enabled.");
    }
}

