/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.correlation;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;

@ConfigSchema(configKey="correlation", configName="correlation", configDescription="Correlation Handler Configuration", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class CorrelationConfig {
    public static final String CONFIG_NAME = "correlation";
    private static final String ENABLED = "enabled";
    private static final String AUTOGEN_CORRELATION_ID = "autogenCorrelationID";
    private static final String TRACEABILITY_MDC_FIELD = "traceabilityMdcField";
    private static final String CORRELATION_MDC_FIELD = "correlationMdcField";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", defaultValue=true, externalized=true, description="If enabled is true, the handler will be injected into the request and response chain.")
    boolean enabled;
    @BooleanField(configFieldName="autogenCorrelationID", externalizedKeyName="autogenCorrelationID", defaultValue=true, externalized=true, description="If set to true, it will auto-generate the correlationID if it is not provided in the request")
    boolean autogenCorrelationID;
    @StringField(configFieldName="correlationMdcField", externalizedKeyName="correlationMdcField", externalized=true, defaultValue="cId", description="The MDC context field name for the correlation id value")
    String correlationMdcField;
    @StringField(configFieldName="traceabilityMdcField", externalizedKeyName="traceabilityMdcField", externalized=true, defaultValue="tId", description="The MDC context field name for the traceability id value")
    String traceabilityMdcField;

    private CorrelationConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private CorrelationConfig() {
        this(CONFIG_NAME);
    }

    public static CorrelationConfig load(String configName) {
        return new CorrelationConfig(configName);
    }

    public static CorrelationConfig load() {
        return new CorrelationConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getTraceabilityMdcField() {
        return this.traceabilityMdcField;
    }

    public void setTraceabilityMdcField(String traceabilityMdcField) {
        this.traceabilityMdcField = traceabilityMdcField;
    }

    public String getCorrelationMdcField() {
        return this.correlationMdcField;
    }

    public void setCorrelationMdcField(String correlationMdcField) {
        this.correlationMdcField = correlationMdcField;
    }

    public boolean isAutogenCorrelationID() {
        return this.autogenCorrelationID;
    }

    public void setAutogenCorrelationID(boolean autogenCorrelationID) {
        this.autogenCorrelationID = autogenCorrelationID;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue(ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(AUTOGEN_CORRELATION_ID)) != null) {
                this.autogenCorrelationID = Config.loadBooleanValue(AUTOGEN_CORRELATION_ID, object);
            }
            if ((object = this.getMappedConfig().get(TRACEABILITY_MDC_FIELD)) != null) {
                this.traceabilityMdcField = (String)object;
            }
            if ((object = this.getMappedConfig().get(CORRELATION_MDC_FIELD)) != null) {
                this.correlationMdcField = (String)object;
            }
        }
    }
}

