/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulThreadMonitor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRecoveryManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRecoveryManager.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private static final AtomicBoolean shutdown = new AtomicBoolean(false);
    private static final AtomicBoolean monitorThreadStarted = new AtomicBoolean(false);
    private static final ConcurrentHashMap<String, Long> heartbeats = new ConcurrentHashMap();
    private static final ConsulThreadMonitor consulThreadMonitor = new ConsulThreadMonitor(heartbeats);
    private boolean isRecoveryMode;
    private long recoveryAttempts = 0L;
    private String serviceName;
    private String tag;

    public ConsulRecoveryManager(String serviceName, String tag) {
        this.serviceName = serviceName;
        this.tag = tag;
        ConsulRecoveryManager.startConsulThreadMonitor();
    }

    private static void startConsulThreadMonitor() {
        if (monitorThreadStarted.get()) {
            return;
        }
        if (monitorThreadStarted.compareAndSet(false, true)) {
            logger.debug("Starting Consul Thread Monitor...");
            consulThreadMonitor.start();
        }
    }

    public boolean exitRecoveryMode() {
        this.recoveryAttempts = 0L;
        boolean oldMode = this.isRecoveryMode;
        this.isRecoveryMode = false;
        return oldMode;
    }

    public boolean newFailedAttempt() {
        this.isRecoveryMode = true;
        ++this.recoveryAttempts;
        logger.error("Recovery mode: Fixing Consul Connection for service {} tag {} - attempt {}...", this.serviceName, this.tag, this.recoveryAttempts);
        if (config.getMaxAttemptsBeforeShutdown() == -1L) {
            return true;
        }
        return config.getMaxAttemptsBeforeShutdown() >= this.recoveryAttempts;
    }

    public static synchronized void gracefulShutdown() {
        if (shutdown.get()) {
            return;
        }
        logger.error("System shutdown initiated - Consul connection could not be reestablished");
        shutdown.set(true);
        System.exit(1);
    }

    public void checkin() {
        logger.debug("Service {} tag {} checking in", (Object)this.serviceName, (Object)this.tag);
        String key = this.tag == null ? this.serviceName : this.serviceName + "|" + this.tag;
        heartbeats.put(key, System.currentTimeMillis());
    }

    public boolean isRecoveryMode() {
        return this.isRecoveryMode;
    }

    public long getRecoveryAttempts() {
        return this.recoveryAttempts;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

