/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema.generator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.Config;
import com.networknt.config.schema.AnnotationUtils;
import com.networknt.config.schema.generator.Generator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.tools.FileObject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class YamlGenerator
extends Generator {
    private static final String EXTERNAL_CONFIG_PREFIX = "${";
    private static final String EXTERNAL_CONFIG_SUFFIX = "}";
    private static final DumperOptions YAML_OPTIONS = new DumperOptions();

    public YamlGenerator(String configKey, String configName) {
        super(configKey, configName);
    }

    @Override
    protected LinkedHashMap<String, Object> getRootSchemaProperties(LinkedHashMap<String, Object> metadata) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        LinkedHashMap metadataProperties = (LinkedHashMap)metadata.get("properties");
        metadataProperties.forEach((key, value) -> {
            LinkedHashMap<String, Object> property = new LinkedHashMap<String, Object>();
            if (!(value instanceof LinkedHashMap)) {
                return;
            }
            this.parseField((LinkedHashMap)value, property);
            properties.putAll(property);
        });
        return properties;
    }

    @Override
    public void writeSchemaToFile(FileObject object, LinkedHashMap<String, Object> metadata) throws IOException {
        this.writeSchemaToFile(object.openOutputStream(), metadata);
    }

    @Override
    public void writeSchemaToFile(OutputStream os, LinkedHashMap<String, Object> metadata) throws IOException {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(this.getRootSchemaProperties(metadata));
        String rootDescription = AnnotationUtils.getAsType(metadata.get("description"), String.class);
        Yaml yaml = new Yaml(new YamlCommentRepresenter(YAML_OPTIONS, metadata, rootDescription), YAML_OPTIONS);
        String fileContent = yaml.dump(json);
        os.write(fileContent.getBytes());
    }

    @Override
    public void writeSchemaToFile(Writer writer, LinkedHashMap<String, Object> metadata) throws IOException {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(this.getRootSchemaProperties(metadata));
        String rootDescription = AnnotationUtils.getAsType(metadata.get("description"), String.class);
        Yaml yaml = new Yaml(new YamlCommentRepresenter(YAML_OPTIONS, metadata, rootDescription), YAML_OPTIONS);
        yaml.dump(json, writer);
    }

    private void buildYamlProperty(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        Boolean externalized = AnnotationUtils.getAsType(field.get("externalized"), Boolean.class);
        boolean isExternalized = externalized != null && externalized != false;
        String externalizedKeyName = AnnotationUtils.getAsType(field.get("externalizedKeyName"), String.class);
        String uuid = AnnotationUtils.getAsType(field.get("$id"), String.class);
        String configFieldName = AnnotationUtils.getAsType(field.get("configFieldName"), String.class);
        Object defaultValue = field.get("defaultValue");
        if (!(defaultValue instanceof String) && defaultValue != null && !isExternalized) {
            property.put(configFieldName, defaultValue);
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (isExternalized) {
            builder.append(EXTERNAL_CONFIG_PREFIX).append(this.configKey).append(".").append(externalizedKeyName).append(":");
        }
        if (isExternalized && defaultValue != null) {
            builder.append(defaultValue);
        } else if (defaultValue != null) {
            ObjectMapper mapper = Config.getInstance().getMapper();
            String stringValue = (String)defaultValue;
            try {
                LinkedHashMap<String, Object> jsonMapValue = mapper.readValue(stringValue, new TypeReference<LinkedHashMap<String, Object>>(){});
                property.put(configFieldName + "___" + uuid, jsonMapValue);
                return;
            }
            catch (Exception me) {
                try {
                    List<String> jsonListValue = mapper.readValue(stringValue, new TypeReference<List<String>>(){});
                    property.put(configFieldName + "___" + uuid, jsonListValue);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (isExternalized) {
            builder.append(EXTERNAL_CONFIG_SUFFIX);
        }
        String propertyValue = builder.toString();
        property.put(configFieldName + "___" + uuid, propertyValue);
    }

    @Override
    protected void parseArray(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        Boolean useSubObjectDefault = AnnotationUtils.getAsType(field.get("useSubObjectDefault"), Boolean.class);
        if (useSubObjectDefault.booleanValue()) {
            if (Generator.fieldIsSubMap(field, "items")) {
                LinkedHashMap props = (LinkedHashMap)field.get("items");
                props.values().forEach(value -> {
                    LinkedHashMap<String, Object> itemProp = new LinkedHashMap<String, Object>();
                    this.parseField((LinkedHashMap)value, itemProp);
                    property.putAll(itemProp);
                });
            }
        } else {
            this.buildYamlProperty(field, property);
        }
    }

    @Override
    protected void parseMapField(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    @Override
    protected void parseBoolean(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    @Override
    protected void parseInteger(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    @Override
    protected void parseNumber(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    @Override
    protected void parseObject(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        Boolean useSubObjectDefault = AnnotationUtils.getAsType(field.get("useSubObjectDefault"), Boolean.class);
        if (useSubObjectDefault != null && useSubObjectDefault.booleanValue()) {
            LinkedHashMap props;
            if (Generator.fieldIsSubMap(field, "properties")) {
                props = (LinkedHashMap)field.get("properties");
            } else if (Generator.fieldIsSubMap(field, "ref")) {
                LinkedHashMap refProps = (LinkedHashMap)field.get("ref");
                props = (LinkedHashMap)refProps.get("properties");
            } else if (Generator.fieldIsSubMap(field, "additionalProperties")) {
                LinkedHashMap additionalProps = (LinkedHashMap)field.get("additionalProperties");
                props = (LinkedHashMap)additionalProps.get("properties");
            } else {
                props = new LinkedHashMap();
            }
            LinkedHashMap objectProperties = new LinkedHashMap();
            props.forEach((key, value) -> this.parseField((LinkedHashMap)value, objectProperties));
            String configFieldName = AnnotationUtils.getAsType(field.get("configFieldName"), String.class);
            String uuid = AnnotationUtils.getAsType(field.get("$id"), String.class);
            property.put(configFieldName + "___" + uuid, objectProperties);
        } else {
            this.buildYamlProperty(field, property);
        }
    }

    @Override
    protected void parseString(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    @Override
    protected void parseNullField(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        this.buildYamlProperty(field, property);
    }

    static {
        YAML_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YAML_OPTIONS.setIndent(2);
        YAML_OPTIONS.setPrettyFlow(true);
        YAML_OPTIONS.setProcessComments(true);
        YAML_OPTIONS.setSplitLines(false);
    }

    public static class YamlCommentRepresenter
    extends Representer {
        public static final String REPRESENTER_SEPARATOR = "___";
        private final AtomicBoolean firstNodeProcessed = new AtomicBoolean(false);

        public YamlCommentRepresenter(DumperOptions options, final LinkedHashMap<String, Object> metadata, final String rootDescription) {
            super(options);
            this.representers.put(String.class, new SafeRepresenter.RepresentString(){

                @Override
                public Node representData(Object data) {
                    String description;
                    String uuid;
                    String configFieldName;
                    String stringData = (String)data;
                    if (stringData.contains(YamlCommentRepresenter.REPRESENTER_SEPARATOR)) {
                        String[] parts = stringData.split(YamlCommentRepresenter.REPRESENTER_SEPARATOR);
                        configFieldName = parts[0];
                        uuid = parts[1];
                    } else {
                        configFieldName = stringData;
                        uuid = null;
                    }
                    Node node = super.representData(configFieldName);
                    Mark start = node.getStartMark();
                    Mark end = node.getEndMark();
                    StringBuilder descriptionBuilder = new StringBuilder();
                    String nodeDescription = this.findCommentForNode(metadata, configFieldName, uuid);
                    if (!firstNodeProcessed.compareAndExchange(false, true) && rootDescription != null) {
                        descriptionBuilder.append(rootDescription);
                        descriptionBuilder.append('\n');
                    }
                    if (nodeDescription != null && !nodeDescription.isEmpty()) {
                        descriptionBuilder.append(nodeDescription);
                    }
                    if (!(description = descriptionBuilder.toString()).isEmpty()) {
                        this.addCommentsToNode(start, end, description, node);
                    }
                    return node;
                }

                private void addCommentsToNode(Mark start, Mark end, String description, Node node) {
                    ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>();
                    if (description.contains("\n")) {
                        String[] lines;
                        for (String line : lines = description.split("\n")) {
                            commentLines.add(new CommentLine(new CommentEvent(CommentType.BLOCK, " " + line, start, end)));
                        }
                    } else {
                        commentLines.add(new CommentLine(new CommentEvent(CommentType.BLOCK, " " + description, start, end)));
                    }
                    node.setBlockComments(commentLines);
                }

                private String findCommentForNode(LinkedHashMap<String, Object> metadata2, String nodeName, String uuid) {
                    String returnString = null;
                    for (Map.Entry<String, Object> entry : metadata2.entrySet()) {
                        if (!(entry.getValue() instanceof LinkedHashMap)) continue;
                        LinkedHashMap field = (LinkedHashMap)entry.getValue();
                        Object fieldId = field.get("$id");
                        if (fieldId != null && entry.getKey().equals(nodeName) && fieldId.equals(uuid)) {
                            returnString = (String)field.get("description");
                            break;
                        }
                        returnString = this.findCommentForNode(field, nodeName, uuid);
                        if (returnString == null) continue;
                        break;
                    }
                    return returnString;
                }
            });
        }
    }
}

