/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema;

import com.networknt.config.schema.AnnotationUtils;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.Format;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.NullField;
import com.networknt.config.schema.NumberField;
import com.networknt.config.schema.ObjectField;
import com.networknt.config.schema.StringField;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.MirroredTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.util.Tuple;

public class MetadataParser {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataParser.class);
    public static final String INTEGER_TYPE = "integer";
    public static final String NUMBER_TYPE = "number";
    public static final String STRING_TYPE = "string";
    public static final String OBJECT_TYPE = "object";
    public static final String ARRAY_TYPE = "array";
    public static final String NULL_TYPE = "null";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String MAP_TYPE = "map";
    public static final String URL_TYPE = "url";
    public static final String URI_TYPE = "uri";
    public static final String TYPE_KEY = "type";
    public static final String ID_KEY = "$id";
    public static final String DESCRIPTION_KEY = "description";
    public static final String EXTERNALIZED_KEY = "externalized";
    public static final String ADDITIONAL_PROPERTIES_KEY = "additionalProperties";
    public static final String DEFAULT_VALUE_KEY = "defaultValue";
    public static final String MINIMUM_KEY = "minimum";
    public static final String MAXIMUM_KEY = "maximum";
    public static final String REF_KEY = "ref";
    public static final String MIN_LENGTH_KEY = "minLength";
    public static final String MAX_LENGTH_KEY = "maxLength";
    public static final String PATTERN_KEY = "pattern";
    public static final String FORMAT_KEY = "format";
    public static final String ITEMS_KEY = "items";
    public static final String EXTERNALIZED_KEY_NAME = "externalizedKeyName";
    public static final String VALUE_TYPE_KEY = "valueType";
    public static final String CONFIG_FIELD_NAME_KEY = "configFieldName";
    public static final String USE_SUB_OBJECT_DEFAULT_KEY = "useSubObjectDefault";
    public static final String MIN_ITEMS_KEY = "minItems";
    public static final String MAX_ITEMS_KEY = "maxItems";
    public static final String UNIQUE_ITEMS_KEY = "uniqueItems";
    public static final String CONTAINS_KEY = "contains";
    public static final String EXCLUSIVE_MIN_KEY = "exclusiveMin";
    public static final String EXCLUSIVE_MAX_KEY = "exclusiveMax";
    public static final String MULTIPLE_OF_KEY = "multipleOf";
    public static final String PROPERTIES_KEY = "properties";
    private static final LinkedHashMap<String, String> DEFAULT_CONTAINER_PROPS = new LinkedHashMap();
    private static final LinkedHashMap<Class<? extends Annotation>, Function<Tuple<Annotation, ProcessingEnvironment>, LinkedHashMap<String, Object>>> FIELD_PARSE_FUNCTIONS;

    public LinkedHashMap<String, Object> parseMetadata(Element element, ProcessingEnvironment processingEnvironment) {
        LinkedHashMap<String, Object> rootMetadata = new LinkedHashMap<String, Object>();
        MetadataParser.gatherObjectSchemaData(element, rootMetadata, processingEnvironment);
        return rootMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private static void gatherObjectSchemaData(Element currentRoot, LinkedHashMap<String, Object> rootMetadata, ProcessingEnvironment processingEnvironment) {
        LOG.trace("Gathering schema data for element: {}", (Object)currentRoot.getSimpleName());
        List<? extends Element> fields2 = currentRoot.getEnclosedElements();
        LinkedHashMap<String, LinkedHashMap<String, Object>> properties = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        String name2 = currentRoot.getSimpleName().toString().toLowerCase();
        for (Element element : fields2) {
            Optional<LinkedHashMap<String, Object>> fieldMetadata = MetadataParser.getObjectPropertyMetadata(element, processingEnvironment);
            if (fieldMetadata.isEmpty()) continue;
            String fieldName = fieldMetadata.get().get(CONFIG_FIELD_NAME_KEY).toString();
            properties.put(fieldName, fieldMetadata.get());
        }
        if (!properties.isEmpty()) {
            rootMetadata.put(PROPERTIES_KEY, properties);
        }
        if (AnnotationUtils.elementImplementsClass(currentRoot, Collection.class, processingEnvironment) || AnnotationUtils.elementIsClass(currentRoot, Collection.class, processingEnvironment)) {
            rootMetadata.put(TYPE_KEY, ARRAY_TYPE);
            if (properties.isEmpty()) {
                rootMetadata.put(ITEMS_KEY, DEFAULT_CONTAINER_PROPS);
            }
        } else if (AnnotationUtils.elementImplementsClass(currentRoot, Map.class, processingEnvironment) || AnnotationUtils.elementIsClass(currentRoot, Map.class, processingEnvironment)) {
            rootMetadata.put(TYPE_KEY, MAP_TYPE);
            if (properties.isEmpty()) {
                rootMetadata.put(ADDITIONAL_PROPERTIES_KEY, DEFAULT_CONTAINER_PROPS);
            }
        } else {
            void var7_15;
            String string = name2;
            int n = -1;
            switch (string.hashCode()) {
                case 64711720: {
                    if (!string.equals(BOOLEAN_TYPE)) break;
                    boolean bl = false;
                    break;
                }
                case 1958052158: {
                    if (!string.equals(INTEGER_TYPE)) break;
                    boolean bl = true;
                    break;
                }
                case -1034364087: {
                    if (!string.equals(NUMBER_TYPE)) break;
                    int n2 = 2;
                    break;
                }
                case -891985903: {
                    if (!string.equals(STRING_TYPE)) break;
                    int n3 = 3;
                    break;
                }
                case 116076: {
                    if (!string.equals(URI_TYPE)) break;
                    int n4 = 4;
                    break;
                }
                case 116079: {
                    if (!string.equals(URL_TYPE)) break;
                    int n5 = 5;
                }
            }
            switch (var7_15) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    rootMetadata.put(TYPE_KEY, name2);
                    break;
                }
                case 4: 
                case 5: {
                    rootMetadata.put(TYPE_KEY, STRING_TYPE);
                    rootMetadata.put(FORMAT_KEY, Format.uri.name());
                    break;
                }
                default: {
                    rootMetadata.put(TYPE_KEY, OBJECT_TYPE);
                }
            }
        }
    }

    private static Optional<LinkedHashMap<String, Object>> getObjectPropertyMetadata(Element element, ProcessingEnvironment processingEnvironment) {
        LOG.trace("Gathering object schema data for property: {}", (Object)element.getSimpleName());
        if (element.getKind() != ElementKind.FIELD) {
            return Optional.empty();
        }
        for (Map.Entry<Class<? extends Annotation>, Function<Tuple<Annotation, ProcessingEnvironment>, LinkedHashMap<String, Object>>> entry : FIELD_PARSE_FUNCTIONS.entrySet()) {
            Class<? extends Annotation> annotationClass = entry.getKey();
            Function<Tuple<Annotation, ProcessingEnvironment>, LinkedHashMap<String, Object>> parseFunction = entry.getValue();
            if (!AnnotationUtils.safeGetAnnotation(element, annotationClass, processingEnvironment).isPresent()) continue;
            Annotation annotation = AnnotationUtils.safeGetAnnotation(element, annotationClass, processingEnvironment).get();
            return Optional.of(parseFunction.apply(new Tuple<Annotation, ProcessingEnvironment>(annotation, processingEnvironment)));
        }
        return Optional.empty();
    }

    private static LinkedHashMap<String, Object> parseArrayMetadata(ArrayField field, ProcessingEnvironment processingEnvironment) {
        String canonicalName;
        try {
            canonicalName = field.items().getCanonicalName();
        }
        catch (MirroredTypeException e) {
            canonicalName = e.getTypeMirrors().get(0).toString();
        }
        Element itemElement = AnnotationUtils.safeGetElement(canonicalName, processingEnvironment);
        LinkedHashMap<String, Object> itemMetadata = new LinkedHashMap<String, Object>();
        MetadataParser.gatherObjectSchemaData(itemElement, itemMetadata, processingEnvironment);
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, ARRAY_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(ITEMS_KEY, itemMetadata);
        metadata.put(MIN_ITEMS_KEY, field.minItems());
        metadata.put(MAX_ITEMS_KEY, field.maxItems());
        metadata.put(UNIQUE_ITEMS_KEY, field.uniqueItems());
        metadata.put(CONTAINS_KEY, field.contains());
        metadata.put(USE_SUB_OBJECT_DEFAULT_KEY, field.useSubObjectDefault());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseMapMetadata(MapField field, ProcessingEnvironment processingEnvironment) {
        String canonicalName;
        try {
            canonicalName = field.valueType().getCanonicalName();
        }
        catch (MirroredTypeException e) {
            canonicalName = e.getTypeMirrors().get(0).toString();
        }
        Element valueElement = AnnotationUtils.safeGetElement(canonicalName, processingEnvironment);
        LinkedHashMap<String, Object> valueMetadata = new LinkedHashMap<String, Object>();
        MetadataParser.gatherObjectSchemaData(valueElement, valueMetadata, processingEnvironment);
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, MAP_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(ADDITIONAL_PROPERTIES_KEY, valueMetadata);
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseIntegerMetadata(IntegerField field) {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, INTEGER_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        metadata.put(MINIMUM_KEY, field.min());
        metadata.put(MAXIMUM_KEY, field.max());
        metadata.put(EXCLUSIVE_MIN_KEY, field.exclusiveMin());
        metadata.put(EXCLUSIVE_MAX_KEY, field.exclusiveMax());
        metadata.put(MULTIPLE_OF_KEY, field.multipleOf());
        metadata.put(FORMAT_KEY, field.format().name());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseNumberMetadata(NumberField field) {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, NUMBER_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        metadata.put(MINIMUM_KEY, field.min());
        metadata.put(MAXIMUM_KEY, field.max());
        metadata.put(EXCLUSIVE_MIN_KEY, field.exclusiveMin());
        metadata.put(EXCLUSIVE_MAX_KEY, field.exclusiveMax());
        metadata.put(MULTIPLE_OF_KEY, field.multipleOf());
        metadata.put(FORMAT_KEY, field.format().name());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseStringMetadata(StringField field) {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, STRING_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        metadata.put(MIN_LENGTH_KEY, field.minLength());
        metadata.put(MAX_LENGTH_KEY, field.maxLength());
        metadata.put(PATTERN_KEY, field.pattern());
        metadata.put(FORMAT_KEY, field.format().name());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseObjectMetadata(ObjectField field, ProcessingEnvironment processingEnvironment) {
        String canonicalName;
        try {
            canonicalName = field.ref().getCanonicalName();
        }
        catch (MirroredTypeException e) {
            canonicalName = e.getTypeMirrors().get(0).toString();
        }
        Element refElement = AnnotationUtils.safeGetElement(canonicalName, processingEnvironment);
        LinkedHashMap<String, Object> refMetadata = new LinkedHashMap<String, Object>();
        MetadataParser.gatherObjectSchemaData(refElement, refMetadata, processingEnvironment);
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, OBJECT_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(USE_SUB_OBJECT_DEFAULT_KEY, field.useSubObjectDefault());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        metadata.put(REF_KEY, refMetadata);
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseNullMetadata(NullField field) {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, NULL_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        return metadata;
    }

    private static LinkedHashMap<String, Object> parseBooleanMetadata(BooleanField field) {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put(TYPE_KEY, BOOLEAN_TYPE);
        metadata.put(ID_KEY, MetadataParser.getUUID());
        metadata.put(EXTERNALIZED_KEY_NAME, field.externalizedKeyName());
        metadata.put(CONFIG_FIELD_NAME_KEY, field.configFieldName());
        metadata.put(DESCRIPTION_KEY, field.description());
        metadata.put(EXTERNALIZED_KEY, field.externalized());
        metadata.put(DEFAULT_VALUE_KEY, field.defaultValue());
        return metadata;
    }

    private static String getUUID() {
        UUID id = UUID.randomUUID();
        return id.toString();
    }

    static {
        DEFAULT_CONTAINER_PROPS.put(TYPE_KEY, STRING_TYPE);
        FIELD_PARSE_FUNCTIONS = new LinkedHashMap();
        FIELD_PARSE_FUNCTIONS.put(BooleanField.class, tuple -> MetadataParser.parseBooleanMetadata((BooleanField)tuple._1()));
        FIELD_PARSE_FUNCTIONS.put(IntegerField.class, tuple -> MetadataParser.parseIntegerMetadata((IntegerField)tuple._1()));
        FIELD_PARSE_FUNCTIONS.put(NullField.class, tuple -> MetadataParser.parseNullMetadata((NullField)tuple._1()));
        FIELD_PARSE_FUNCTIONS.put(ObjectField.class, tuple -> MetadataParser.parseObjectMetadata((ObjectField)tuple._1(), (ProcessingEnvironment)tuple._2()));
        FIELD_PARSE_FUNCTIONS.put(StringField.class, tuple -> MetadataParser.parseStringMetadata((StringField)tuple._1()));
        FIELD_PARSE_FUNCTIONS.put(NumberField.class, tuple -> MetadataParser.parseNumberMetadata((NumberField)tuple._1()));
        FIELD_PARSE_FUNCTIONS.put(ArrayField.class, tuple -> MetadataParser.parseArrayMetadata((ArrayField)tuple._1(), (ProcessingEnvironment)tuple._2()));
        FIELD_PARSE_FUNCTIONS.put(MapField.class, tuple -> MetadataParser.parseMapMetadata((MapField)tuple._1(), (ProcessingEnvironment)tuple._2()));
    }
}

