/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema;

import com.networknt.config.schema.AnnotationUtils;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.MetadataParser;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.generator.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.networknt.config.schema.ConfigSchema"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConfigAnnotationParser
extends AbstractProcessor {
    private MetadataParser metadataParser;
    private static final String BUILD_COMMAND_PROPERTY = "sun.java.command";
    private static final String PROFILE_FLAG = "-P";
    private static final String SCHEMA_GENERATION_PROFILE = "schema-generation";
    private ProcessingEnvironment processingEnv;
    private boolean generated = false;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        this.metadataParser = new MetadataParser();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations2, RoundEnvironment roundEnv) {
        int x;
        Set<? extends Element> configs = roundEnv.getElementsAnnotatedWith(ConfigSchema.class);
        if (roundEnv.processingOver() || this.generated) {
            return true;
        }
        boolean schemaEnabled = false;
        String javaCmd = System.getProperty(BUILD_COMMAND_PROPERTY);
        String[] cmdProps = javaCmd.split(" ");
        if (cmdProps.length == 0) {
            return true;
        }
        boolean profilesDefined = false;
        for (x = 0; x < cmdProps.length; ++x) {
            if (!cmdProps[x].equals(PROFILE_FLAG)) continue;
            ++x;
            profilesDefined = true;
            break;
        }
        if (!profilesDefined) {
            System.out.println("No profiles defined, skipping schema-generation...");
            return true;
        }
        String[] profileArr = cmdProps[x].split(",");
        for (String profile : profileArr) {
            if (!profile.equals(SCHEMA_GENERATION_PROFILE)) continue;
            schemaEnabled = true;
            break;
        }
        if (!schemaEnabled) {
            System.out.println("schema-generation profile is disabled, skipping schema generation...");
            return true;
        }
        for (Element element : configs) {
            ConfigSchema configClassMetadata = element.getAnnotation(ConfigSchema.class);
            Path modulePath = this.getPathInCurrentModule("../../src/main/resources/config/", configClassMetadata.configKey() + "_module");
            Path targetPathMirror = this.getPathInCurrentModule("config/", configClassMetadata.configKey() + "_target");
            LinkedHashMap<String, Object> configMetadata = this.metadataParser.parseMetadata(element, this.processingEnv);
            AnnotationUtils.updateIfNotDefault(configMetadata, configClassMetadata.configDescription(), "description", "");
            for (OutputFormat output : configClassMetadata.outputFormats()) {
                String extension = output.getExtension();
                Path projectFile = this.resolveOrCreateFile(modulePath, configClassMetadata.configName() + extension).toPath();
                try (BufferedWriter writer = Files.newBufferedWriter(projectFile, new OpenOption[0]);){
                    Generator.getGenerator(output, configClassMetadata.configKey(), configClassMetadata.configName()).writeSchemaToFile(writer, configMetadata);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error generating config file", e);
                }
                Path targetFile = this.resolveOrCreateFile(targetPathMirror, configClassMetadata.configName() + extension).toPath();
                try (BufferedWriter writer = Files.newBufferedWriter(targetFile, new OpenOption[0]);){
                    Generator.getGenerator(output, configClassMetadata.configKey(), configClassMetadata.configName()).writeSchemaToFile(writer, configMetadata);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error generating config file", e);
                }
            }
        }
        this.generated = true;
        return true;
    }

    private File resolveOrCreateFile(Path path, String fileName) {
        File file = path.resolve(fileName).toFile();
        if (!file.exists()) {
            try {
                if (file.createNewFile()) {
                    System.out.println("File " + file.getName() + " created.");
                } else {
                    System.out.println("File " + file.getName() + " already exists, the existing file will have it's contents overwritten.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create a new file '" + fileName + "', for the directory '" + String.valueOf(file) + "'. " + e.getMessage());
            }
        }
        return file;
    }

    private Path getPathInCurrentModule(String relativeModulePath, String tempAnchorName) {
        FileObject resource;
        String path = Objects.requireNonNullElse(relativeModulePath, "");
        try {
            resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "anchor" + tempAnchorName, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temp resource to find the current module", e);
        }
        return Paths.get(resource.toUri()).getParent().resolve(path);
    }
}

