/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.rest;

import com.networknt.client.http.Http2ServiceRequest;
import com.networknt.client.model.ServiceDef;
import com.networknt.client.rest.RestClient;
import com.networknt.client.rest.RestClientException;
import com.networknt.status.HttpStatus;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class RestClientTemplate
implements RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClientTemplate.class);
    private OptionMap restOptions;
    Optional<List<HttpStatus>> statusCodesValid = Optional.empty();

    public RestClientTemplate() {
        this.restOptions = OptionMap.EMPTY;
    }

    public void setStatusCodesValid(List<HttpStatus> statusCodesValid) {
        this.statusCodesValid = Optional.of(statusCodesValid);
    }

    public RestClientTemplate(OptionMap restOptions) {
        this.restOptions = restOptions != null ? restOptions : OptionMap.EMPTY;
    }

    @Override
    public String get(String url, String path) throws RestClientException {
        return this.get(url, path, String.class);
    }

    @Override
    public <T> T get(String url, String path, Class<T> responseType) throws RestClientException {
        return this.get(url, path, responseType, null);
    }

    @Override
    public <T> T get(ServiceDef serviceDef, String path, Class<T> responseType) throws RestClientException {
        return this.execute(serviceDef, path, responseType, null, Methods.GET, null);
    }

    @Override
    public <T> T get(ServiceDef serviceDef, String path, Class<T> responseType, Map<String, ?> headerMap) throws RestClientException {
        return this.execute(serviceDef, path, responseType, headerMap, Methods.GET, null);
    }

    @Override
    public String get(ServiceDef serviceDef, String path) throws RestClientException {
        return this.get(serviceDef, path, String.class);
    }

    @Override
    public <T> T get(String url, String path, Class<T> responseType, Map<String, ?> headerMap) throws RestClientException {
        return this.execute(url, path, responseType, headerMap, Methods.GET, null);
    }

    @Override
    public <T> T post(String url, String path, Class<T> responseType, String requestBody) throws RestClientException {
        return this.post(url, path, responseType, null, requestBody);
    }

    @Override
    public String post(String url, String path, String requestBody) throws RestClientException {
        return this.post(url, path, String.class, requestBody);
    }

    @Override
    public <T> T post(String url, String path, Class<T> responseType, Map<String, ?> headerMap, String requestBody) throws RestClientException {
        return this.execute(url, path, responseType, headerMap, Methods.POST, requestBody);
    }

    @Override
    public String post(ServiceDef serviceDef, String path, String requestBody) throws RestClientException {
        return this.post(serviceDef, path, String.class, requestBody);
    }

    @Override
    public <T> T post(ServiceDef serviceDef, String path, Class<T> responseType, String requestBody) throws RestClientException {
        return this.post(serviceDef, path, responseType, null, requestBody);
    }

    @Override
    public <T> T post(ServiceDef serviceDef, String path, Class<T> responseType, Map<String, ?> headerMap, String requestBody) throws RestClientException {
        return this.execute(serviceDef, path, responseType, headerMap, Methods.POST, requestBody);
    }

    @Override
    public String put(String url, String path, String requestBody) throws RestClientException {
        return this.put(url, path, null, requestBody);
    }

    @Override
    public String put(String url, String path, Map<String, ?> headerMap, String requestBody) throws RestClientException {
        return this.execute(url, path, String.class, headerMap, Methods.PUT, requestBody);
    }

    @Override
    public String put(ServiceDef serviceDef, String path, String requestBody) throws RestClientException {
        return this.execute(serviceDef, path, String.class, null, Methods.PUT, requestBody);
    }

    @Override
    public String put(ServiceDef serviceDef, String path, Map<String, ?> headerMap, String requestBody) throws RestClientException {
        return this.execute(serviceDef, path, String.class, headerMap, Methods.PUT, requestBody);
    }

    @Override
    public String delete(String url, String path) throws RestClientException {
        return this.delete(url, path, null, null);
    }

    @Override
    public String delete(String url, String path, Map<String, ?> headerMap, String requestBody) throws RestClientException {
        return this.execute(url, path, String.class, headerMap, Methods.DELETE, requestBody);
    }

    @Override
    public String delete(ServiceDef serviceDef, String path) throws RestClientException {
        return this.execute(serviceDef, path, String.class, null, Methods.DELETE, null);
    }

    protected <T> T execute(String url, String path, Class<T> responseType, Map<String, ?> headerMap, HttpString method, String requestBody) throws RestClientException {
        try {
            Http2ServiceRequest http2ServiceRequest = new Http2ServiceRequest(new URI(url), path, method);
            if (this.statusCodesValid.isPresent()) {
                http2ServiceRequest.setStatusCodesValid(this.statusCodesValid.get());
            }
            http2ServiceRequest.setRequestHeaders(headerMap);
            if (requestBody != null) {
                http2ServiceRequest.setRequestBody(requestBody);
            }
            return http2ServiceRequest.callForTypedObject(responseType).get();
        }
        catch (Exception e) {
            String errorStr = "execute the restful API call error:";
            logger.error(errorStr + String.valueOf(e));
            throw new RestClientException(errorStr, e);
        }
    }

    protected <T> T execute(ServiceDef serviceDef, String path, Class<T> responseType, Map<String, ?> headerMap, HttpString method, String requestBody) throws RestClientException {
        try {
            Http2ServiceRequest http2ServiceRequest = new Http2ServiceRequest(serviceDef, path, method);
            if (this.statusCodesValid.isPresent()) {
                http2ServiceRequest.setStatusCodesValid(this.statusCodesValid.get());
            }
            http2ServiceRequest.setRequestHeaders(headerMap);
            if (requestBody != null) {
                http2ServiceRequest.setRequestBody(requestBody);
            }
            return http2ServiceRequest.callForTypedObject(responseType).get();
        }
        catch (Exception e) {
            String errorStr = "execute the restful API call error:";
            logger.error(errorStr + String.valueOf(e));
            throw new RestClientException(errorStr, e);
        }
    }
}

