/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.IntrospectionRequest;
import com.networknt.config.Config;
import com.networknt.status.Status;
import com.networknt.utility.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenIntrospectionRequest
extends IntrospectionRequest {
    private static Logger logger = LoggerFactory.getLogger(TokenIntrospectionRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";

    public TokenIntrospectionRequest(String swt) {
        this(swt, null);
    }

    public TokenIntrospectionRequest(String swt, Map<String, Object> introspectionConfig) {
        super(swt);
        Map<String, Object> clientConfig = ClientConfig.get().getMappedConfig();
        if (clientConfig != null) {
            Map oauthConfig = (Map)clientConfig.get("oauth");
            if (oauthConfig != null) {
                Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
                if (tokenConfig != null) {
                    this.setProxyHost((String)tokenConfig.get("proxyHost"));
                    int port = tokenConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue("proxyPort", tokenConfig.get("proxyPort"));
                    this.setProxyPort(port);
                    Map keyConfig = (Map)tokenConfig.get("key");
                    if (keyConfig != null) {
                        this.setIntrospectionOptions(keyConfig);
                    } else {
                        logger.error(new Status(CONFIG_PROPERTY_MISSING, "key section", "client.yml").toString());
                    }
                    if (introspectionConfig != null && introspectionConfig.size() > 0) {
                        this.setIntrospectionOptions(introspectionConfig);
                    }
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, "token section", "client.yml").toString());
                }
            } else {
                logger.error(new Status(CONFIG_PROPERTY_MISSING, "oauth section", "client.yml").toString());
            }
        } else {
            logger.error(new Status(CONFIG_PROPERTY_MISSING, "client section", "client.yml").toString());
        }
    }

    private void setIntrospectionOptions(Map<String, Object> introspectionConfig) {
        if (introspectionConfig.get("server_url") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old serverUrl {} with new serverUrl {}", (Object)this.getServerUrl(), introspectionConfig.get("server_url"));
            }
            this.setServerUrl((String)introspectionConfig.get("server_url"));
        }
        if (introspectionConfig.get("serviceId") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old serviceId {} with new serviceId {}", (Object)this.getServiceId(), introspectionConfig.get("serviceId"));
            }
            this.setServiceId((String)introspectionConfig.get("serviceId"));
        }
        if (introspectionConfig.get("enableHttp2") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old enableHttp2 {} with new enableHttp2 {}", (Object)this.isEnableHttp2(), introspectionConfig.get("enableHttp2"));
            }
            Object object = introspectionConfig.get("enableHttp2");
            this.setEnableHttp2(Config.loadBooleanValue("enableHttp2", object));
        }
        if (introspectionConfig.get("uri") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old uri {} with new uri {}", (Object)this.getUri(), introspectionConfig.get("uri"));
            }
            this.setUri((String)introspectionConfig.get("uri"));
        }
        if (introspectionConfig.get("client_id") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old clientId {} with new clientId {}", (Object)this.getClientId(), introspectionConfig.get("client_id"));
            }
            this.setClientId((String)introspectionConfig.get("client_id"));
        }
        if (introspectionConfig.get("client_secret") != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old clientSecret {} with new clientSecret {}", (Object)StringUtils.maskHalfString(this.getClientSecret()), (Object)StringUtils.maskHalfString((String)introspectionConfig.get("client_secret")));
            }
            this.setClientSecret((String)introspectionConfig.get("client_secret"));
        }
        if (introspectionConfig.get("proxyHost") != null) {
            String proxyHost;
            if (logger.isTraceEnabled()) {
                logger.trace("overwrite old proxyHost {} with new proxyHost {}", (Object)this.getProxyHost(), introspectionConfig.get("proxyHost"));
            }
            if ((proxyHost = (String)introspectionConfig.get("proxyHost")).length() > 1) {
                this.setProxyHost(proxyHost);
                int port = introspectionConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue("proxyPort", introspectionConfig.get("proxyPort"));
                this.setProxyPort(port);
            } else {
                this.setProxyHost(null);
                this.setProxyPort(0);
            }
        }
    }
}

