/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.oauth.IClientRequestComposable;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.TokenRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestComposerProvider {
    private static final ClientRequestComposerProvider INSTANCE = new ClientRequestComposerProvider();
    private Map<ClientRequestComposers, IClientRequestComposable> composersMap = new HashMap<ClientRequestComposers, IClientRequestComposable>();
    private static final Logger logger = LoggerFactory.getLogger(ClientRequestComposerProvider.class);

    private ClientRequestComposerProvider() {
    }

    public static ClientRequestComposerProvider getInstance() {
        return INSTANCE;
    }

    public IClientRequestComposable getComposer(ClientRequestComposers composerName) {
        IClientRequestComposable composer = this.composersMap.get((Object)composerName);
        if (composer == null) {
            this.initDefaultComposer(composerName);
        }
        return this.composersMap.get((Object)composerName);
    }

    private void initDefaultComposer(ClientRequestComposers composerName) {
        switch (composerName) {
            case CLIENT_CREDENTIAL_REQUEST_COMPOSER: {
                this.composersMap.put(ClientRequestComposers.CLIENT_CREDENTIAL_REQUEST_COMPOSER, new DefaultClientCredentialRequestComposer());
                break;
            }
            case SAML_BEARER_REQUEST_COMPOSER: {
                this.composersMap.put(ClientRequestComposers.SAML_BEARER_REQUEST_COMPOSER, new DefaultSAMLBearerRequestComposer());
                break;
            }
            case CLIENT_AUTHENTICATED_USER_REQUEST_COMPOSER: {
                this.composersMap.put(ClientRequestComposers.CLIENT_AUTHENTICATED_USER_REQUEST_COMPOSER, new DefaultClientAuthenticatedUserRequestComposer());
                break;
            }
        }
    }

    public void registerComposer(ClientRequestComposers composerName, IClientRequestComposable composer) {
        this.composersMap.put(composerName, composer);
    }

    public static String getFormDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result2 = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result2.append("&");
            }
            result2.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result2.append("=");
            result2.append(URLEncoder.encode(entry.getValue(), "UTF-8").replaceAll("\\+", "%20"));
        }
        return result2.toString();
    }

    private static class DefaultClientAuthenticatedUserRequestComposer
    implements IClientRequestComposable {
        private DefaultClientAuthenticatedUserRequestComposer() {
        }

        @Override
        public HttpRequest composeClientRequest(TokenRequest tokenRequest) {
            HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(this.composeRequestBody(tokenRequest))).uri(URI.create(tokenRequest.getServerUrl() + tokenRequest.getUri())).setHeader("Content-Type", "application/x-www-form-urlencoded").setHeader("Authorization", OauthHelper.getBasicAuthHeader(tokenRequest.getClientId(), tokenRequest.getClientSecret())).build();
            return request;
        }

        public String composeRequestBody(TokenRequest tokenRequest) {
            try {
                return OauthHelper.getEncodedString(tokenRequest);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("get encoded string from tokenRequest fails: \n {}", (Object)e.toString());
                return "";
            }
        }
    }

    private static class DefaultClientCredentialRequestComposer
    implements IClientRequestComposable {
        private DefaultClientCredentialRequestComposer() {
        }

        @Override
        public HttpRequest composeClientRequest(TokenRequest tokenRequest) {
            HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(this.composeRequestBody(tokenRequest))).uri(URI.create(tokenRequest.getServerUrl() + tokenRequest.getUri())).setHeader("Content-Type", "application/x-www-form-urlencoded").setHeader("Accept", "application/json").setHeader("Authorization", OauthHelper.getBasicAuthHeader(tokenRequest.getClientId(), tokenRequest.getClientSecret())).build();
            if (logger.isTraceEnabled()) {
                logger.trace("request = " + request.toString());
            }
            return request;
        }

        public String composeRequestBody(TokenRequest tokenRequest) {
            try {
                return OauthHelper.getEncodedString(tokenRequest);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("get encoded string from tokenRequest fails: \n {}", (Object)e.toString());
                return "";
            }
        }
    }

    private static class DefaultSAMLBearerRequestComposer
    implements IClientRequestComposable {
        private DefaultSAMLBearerRequestComposer() {
        }

        @Override
        public HttpRequest composeClientRequest(TokenRequest tokenRequest) {
            HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(this.composeRequestBody(tokenRequest))).uri(URI.create(tokenRequest.getServerUrl() + tokenRequest.getUri())).header("Content-Type", "application/x-www-form-urlencoded").build();
            return request;
        }

        public String composeRequestBody(TokenRequest tokenRequest) {
            SAMLBearerRequest SamlTokenRequest = (SAMLBearerRequest)tokenRequest;
            HashMap<String, String> postBody = new HashMap<String, String>();
            postBody.put("grant_type", "urn:ietf:params:oauth:grant-type:saml2-bearer");
            postBody.put("assertion", SamlTokenRequest.getSamlAssertion());
            postBody.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            postBody.put("client_assertion", SamlTokenRequest.getJwtClientAssertion());
            try {
                return ClientRequestComposerProvider.getFormDataString(postBody);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("get encoded string from tokenRequest fails: \n {}", (Object)e.toString());
                return "";
            }
        }
    }

    public static enum ClientRequestComposers {
        CLIENT_CREDENTIAL_REQUEST_COMPOSER,
        SAML_BEARER_REQUEST_COMPOSER,
        CLIENT_AUTHENTICATED_USER_REQUEST_COMPOSER;

    }
}

