/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.ClientConfig;
import io.undertow.client.ClientConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(Http2ClientConnectionPool.class);
    private final Map<String, List<CachedConnection>> connectionPool;
    private static Map<String, List<CachedConnection>> clientConnectionParkedMap = new HashMap<String, List<CachedConnection>>();
    private final Map<ClientConnection, ConnectionStatus> connectionStatusMap;
    private static Http2ClientConnectionPool http2ClientConnectionPool;
    private AtomicInteger connectionCount;

    private Http2ClientConnectionPool() {
        final int poolSize = ClientConfig.get().getConnectionPoolSize();
        this.connectionCount = new AtomicInteger(0);
        this.connectionPool = Collections.synchronizedMap(new LinkedHashMap<String, List<CachedConnection>>((int)Math.ceil((float)poolSize / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, List<CachedConnection>> eldest) {
                if (Http2ClientConnectionPool.this.connectionPool.size() > poolSize) {
                    for (CachedConnection connection : eldest.getValue()) {
                        Http2ClientConnectionPool.this.connectionStatusMap.remove(connection.get());
                        Http2ClientConnectionPool.this.connectionCount.getAndDecrement();
                    }
                    return true;
                }
                return false;
            }
        });
        this.connectionStatusMap = new ConcurrentHashMap<ClientConnection, ConnectionStatus>((int)Math.ceil((float)poolSize / 0.75f) + 1, 0.75f);
    }

    public static Http2ClientConnectionPool getInstance() {
        if (http2ClientConnectionPool == null) {
            http2ClientConnectionPool = new Http2ClientConnectionPool();
        }
        return http2ClientConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ClientConnection getConnection(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        List<CachedConnection> result2 = this.connectionPool.get(uriString);
        if (result2 == null) {
            Class<Http2ClientConnectionPool> clazz = Http2ClientConnectionPool.class;
            // MONITORENTER : com.networknt.client.http.Http2ClientConnectionPool.class
            if (logger.isDebugEnabled()) {
                logger.debug("Second try of getting connections for uri: {}", (Object)uriString);
            }
            result2 = this.connectionPool.get(uriString);
            // MONITOREXIT : clazz
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got {} connections for uri: {}", (Object)(result2 != null ? Integer.valueOf(result2.size()) : null), (Object)uriString);
        }
        CachedConnection cachedConnection = this.selectConnection(uri, result2, false);
        if (logger.isDebugEnabled()) {
            logger.debug("Got cached connection: {} for uri: {}", (Object)cachedConnection, (Object)uriString);
        }
        if (cachedConnection == null) return null;
        this.hangConnection(uri, cachedConnection);
        return cachedConnection.get();
    }

    public synchronized void cacheConnection(URI uri, ClientConnection connection) {
        CachedConnection cachedConnection = this.getAndRemoveClosedConnection(uri);
        if (cachedConnection == null || this.getConnectionStatus(uri, cachedConnection) != ConnectionStatus.MULTIPLEX_SUPPORT) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cached connection: {} is either null or not support multiplex", (Object)cachedConnection);
            }
            CachedConnection newConnection = new CachedConnection(connection);
            this.connectionPool.computeIfAbsent(uri.toString(), k -> new LinkedList()).add(newConnection);
            this.connectionCount.getAndIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized CachedConnection getAndRemoveClosedConnection(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        List<CachedConnection> result2 = this.connectionPool.get(uriString);
        if (result2 == null) {
            Class<Http2ClientConnectionPool> clazz = Http2ClientConnectionPool.class;
            // MONITORENTER : com.networknt.client.http.Http2ClientConnectionPool.class
            result2 = this.connectionPool.get(uriString);
            // MONITOREXIT : clazz
        }
        if (!logger.isDebugEnabled()) return this.selectConnection(uri, result2, true);
        logger.debug("Got {} cache connections for uri: {} from connectionPool", (Object)(result2 != null ? Integer.valueOf(result2.size()) : null), (Object)uriString);
        return this.selectConnection(uri, result2, true);
    }

    private void handleParkedConnection(URI uri, CachedConnection connection) {
        block9: {
            if (connection == null) {
                return;
            }
            if (uri == null) {
                return;
            }
            String host = uri.toString();
            List<CachedConnection> parkedConList = clientConnectionParkedMap.get(host);
            if (parkedConList == null) {
                parkedConList = new ArrayList<CachedConnection>();
                clientConnectionParkedMap.put(host, parkedConList);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Total parked connection for the host {} is {}", (Object)host, (Object)parkedConList.size());
            }
            Iterator<CachedConnection> iter = parkedConList.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isParkedConnectionExpired()) continue;
                iter.remove();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Removing the expired Parked Connection for the host {}", (Object)host);
            }
            try {
                if (connection.get().isOpen()) {
                    parkedConList.add(connection);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parked the connection for the host {}, total parked count is {}", (Object)host, (Object)parkedConList.size());
                    }
                }
            }
            catch (Exception ignored) {
                if (!logger.isInfoEnabled()) break block9;
                logger.info("Exception while handling the parked connection. Exception is :", ignored);
            }
        }
    }

    private synchronized CachedConnection selectConnection(URI uri, List<CachedConnection> connections, boolean isRemoveClosedConnection) {
        if (connections != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Before removing max connections per host from list of {} connections for uri: {} ...", (Object)connections.size(), (Object)uri);
            }
            if ((double)connections.size() > (double)ClientConfig.get().getMaxConnectionNumPerHost() * 0.75) {
                while (connections.size() > ClientConfig.get().getMinConnectionNumPerHost() && connections.size() > 0) {
                    connections.remove(0);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("After removing max connections per host from list of {} connections for uri: {} ...", (Object)connections.size(), (Object)uri);
            }
            if (isRemoveClosedConnection) {
                Iterator<CachedConnection> iterator2 = connections.iterator();
                while (iterator2.hasNext()) {
                    ConnectionStatus status;
                    CachedConnection connection = iterator2.next();
                    if (connection == null || ConnectionStatus.CLOSE != (status = this.getConnectionStatus(uri, connection))) continue;
                    iterator2.remove();
                    this.connectionStatusMap.remove(connection.get());
                    this.connectionCount.getAndDecrement();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("After removing closed connections, {} connections left in the list for uri: {}", (Object)connections.size(), (Object)uri);
                }
            }
            if (connections.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Selecting a valid connections from cached {} connections for uri: {} ...", (Object)connections.size(), (Object)uri);
                }
                int randomInt = ThreadLocalRandom.current().nextInt(0, connections.size());
                for (int i = 0; i < connections.size(); ++i) {
                    CachedConnection connection = connections.get((i + randomInt) % connections.size());
                    ConnectionStatus status = this.getConnectionStatus(uri, connection);
                    if (status == ConnectionStatus.AVAILABLE || status == ConnectionStatus.MULTIPLEX_SUPPORT) {
                        return connection;
                    }
                    logger.warn("Connection status for uri: {} is {}", (Object)uri, (Object)status);
                }
                logger.warn("None of the connection cached can be used for uri: {}", (Object)uri);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ConnectionStatus getConnectionStatus(URI uri, CachedConnection connection) {
        ConnectionStatus status = this.connectionStatusMap.get(connection.get());
        if (status == null) {
            Class<Http2ClientConnectionPool> clazz = Http2ClientConnectionPool.class;
            // MONITORENTER : com.networknt.client.http.Http2ClientConnectionPool.class
            status = this.connectionStatusMap.get(connection.get());
            // MONITOREXIT : clazz
        }
        if (connection != null && connection.isOpen()) {
            if (!connection.isHttp2Connection()) return status;
            return ConnectionStatus.MULTIPLEX_SUPPORT;
        }
        if (connection == null) {
            return ConnectionStatus.CLOSE;
        }
        this.handleParkedConnection(uri, connection);
        return ConnectionStatus.CLOSE;
    }

    public void resetConnectionStatus(ClientConnection connection) {
        if (connection != null) {
            if (!connection.isOpen()) {
                this.connectionStatusMap.remove(connection);
            } else if (connection.isMultiplexingSupported()) {
                this.connectionStatusMap.put(connection, ConnectionStatus.MULTIPLEX_SUPPORT);
            } else {
                this.connectionStatusMap.put(connection, ConnectionStatus.AVAILABLE);
            }
        }
    }

    private void hangConnection(URI uri, CachedConnection connection) {
        if (connection != null) {
            connection.incrementRequestCount();
            ConnectionStatus status = this.getConnectionStatus(uri, connection);
            if (logger.isDebugEnabled()) {
                logger.debug("Got connection status: {} for uri: {} before hang it", (Object)status, (Object)uri);
            }
            if (status == null && !connection.isHttp2Connection() || status == ConnectionStatus.AVAILABLE) {
                this.connectionStatusMap.put(connection.get(), ConnectionStatus.HANGING);
            }
        }
    }

    public int numberOfConnections() {
        return this.connectionCount.get();
    }

    public void clear() {
        this.connectionCount = new AtomicInteger(0);
        this.connectionStatusMap.clear();
        this.connectionPool.clear();
    }

    private class CachedConnection {
        private AtomicInteger requestCount;
        private ClientConnection clientConnection;
        private long lifeStartTime;
        private long ttlParked = 100000L;
        private long lifeStartTimeParked;
        private int maxReqCount = ClientConfig.get().getMaxRequestPerConnection();
        private long expireTime = ClientConfig.get().getConnectionExpireTime();

        protected CachedConnection(ClientConnection connection) {
            this.requestCount = new AtomicInteger(0);
            this.clientConnection = connection;
            this.lifeStartTime = System.currentTimeMillis();
        }

        public boolean isOpen() {
            if (System.currentTimeMillis() - this.lifeStartTime >= this.expireTime || this.requestCount.get() >= this.maxReqCount && this.maxReqCount != -1) {
                logger.debug("Connection expired. Start time of this connection is {}. The total request count is {}", (Object)new Date(this.lifeStartTime), (Object)this.requestCount);
                this.lifeStartTimeParked = System.currentTimeMillis();
                this.requestCount = new AtomicInteger(0);
                return false;
            }
            return this.clientConnection.isOpen();
        }

        protected boolean isHttp2Connection() {
            return this.clientConnection.isMultiplexingSupported();
        }

        public ClientConnection get() {
            return this.clientConnection;
        }

        protected void incrementRequestCount() {
            this.requestCount.getAndIncrement();
        }

        public boolean isParkedConnectionExpired() {
            if (System.currentTimeMillis() > this.lifeStartTimeParked + this.ttlParked) {
                block4: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("ParkedConnection expired. Start time of this parked connection is {}", (Object)new Date(this.lifeStartTimeParked));
                    }
                    try {
                        this.clientConnection.close();
                    }
                    catch (Exception ignored) {
                        if (!logger.isInfoEnabled()) break block4;
                        logger.info("Exception while closing the parked connection. This exception is suppressed. Exception is {}", ignored);
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static enum ConnectionStatus {
        HANGING,
        AVAILABLE,
        CLOSE,
        MULTIPLEX_SUPPORT;

    }
}

