/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.StringField;
import java.util.Map;

public class TlsConfig {
    public static final String VERIFY_HOSTNAME = "verifyHostname";
    public static final String LOAD_DEFAULT_TRUST_STORE = "loadDefaultTrustStore";
    public static final String LOAD_TRUST_STORE = "loadTrustStore";
    public static final String TRUST_STORE = "trustStore";
    public static final String TRUST_STORE_PASS = "trustStorePass";
    public static final String LOAD_KEY_STORE = "loadKeyStore";
    public static final String KEY_STORE = "keyStore";
    public static final String KEY_STORE_PASS = "keyStorePass";
    public static final String KEY_PASS = "keyPass";
    public static final String DEFAULT_CERT_PASSWORD = "defaultCertPassword";
    public static final String TLS_VERSION = "tlsVersion";
    @BooleanField(configFieldName="verifyHostname", externalizedKeyName="verifyHostname", externalized=true, defaultValue=true, description="if the server is using self-signed certificate, this need to be false. If true, you have to use CA signed certificate or load\ntruststore that contains the self-signed certificate.")
    private boolean verifyHostname;
    @BooleanField(configFieldName="loadDefaultTrustStore", externalizedKeyName="loadDefaultTrustStore", externalized=true, defaultValue=true, description="indicate of system load default cert.")
    private boolean loadDefaultTrustStore;
    @BooleanField(configFieldName="loadTrustStore", externalizedKeyName="loadTrustStore", externalized=true, defaultValue=true, description="trust store contains certificates that server needs. Enable if tls is used.")
    private boolean loadTrustStore;
    @StringField(configFieldName="trustStore", externalizedKeyName="trustStore", externalized=true, defaultValue="client.truststore", description="trust store location can be specified here or system properties javax.net.ssl.trustStore and password javax.net.ssl.trustStorePassword")
    private String trustStore;
    @StringField(configFieldName="trustStorePass", externalizedKeyName="trustStorePass", externalized=true, defaultValue="password", description="trust store password")
    private char[] trustStorePass;
    @BooleanField(configFieldName="loadKeyStore", externalizedKeyName="loadKeyStore", externalized=true, description="key store contains client key and it should be loaded if two-way ssl is used.")
    private boolean loadKeyStore;
    @StringField(configFieldName="keyStore", externalizedKeyName="keyStore", externalized=true, defaultValue="client.keystore", description="key store location")
    private String keyStore;
    @StringField(configFieldName="keyStorePass", externalizedKeyName="keyStorePass", externalized=true, defaultValue="password", description="key store password")
    private char[] keyStorePass;
    @StringField(configFieldName="keyPass", externalizedKeyName="keyPass", externalized=true, defaultValue="password", description="private key password")
    private char[] keyPass;
    @StringField(configFieldName="defaultCertPassword", externalizedKeyName="defaultCertPassword", externalized=true, defaultValue="changeit", description="public issued CA cert password")
    private char[] defaultCertPassword;
    @StringField(configFieldName="tlsVersion", externalizedKeyName="tlsVersion", externalized=true, defaultValue="TLSv1.3", description="TLS version. Default is TSLv1.3, and you can downgrade to TLSv1.2 to support some internal old servers that support only TLSv1.1\nand 1.2 (deprecated and risky).")
    String tlsVersion;
    @StringField(configFieldName="defaultGroupKey", externalizedKeyName="defaultGroupKey", externalized=true)
    String defaultGroupKey;
    @MapField(configFieldName="trustedNames", externalizedKeyName="trustedNames", externalized=true, valueType=String.class)
    Map<String, String> trustedNames;

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public boolean isLoadDefaultTrustStore() {
        return this.loadDefaultTrustStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public char[] getTrustStorePass() {
        return this.trustStorePass;
    }

    public boolean isLoadTrustStore() {
        return this.loadTrustStore;
    }

    public boolean isLoadKeyStore() {
        return this.loadKeyStore;
    }

    public char[] getDefaultCertPassword() {
        return this.defaultCertPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public char[] getKeyStorePass() {
        return this.keyStorePass;
    }

    public char[] getKeyPass() {
        return this.keyPass;
    }

    public String getTlsVersion() {
        return this.tlsVersion;
    }

    public String getDefaultGroupKey() {
        return this.defaultGroupKey;
    }

    public Map<String, String> getTrustedNames() {
        return this.trustedNames;
    }
}

