/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.IntegerField;

public class RequestConfig {
    public static final String ERROR_THRESHOLD = "errorThreshold";
    public static final String TIMEOUT = "timeout";
    public static final String RESET_TIMEOUT = "resetTimeout";
    public static final String INJECT_OPEN_TRACING = "injectOpenTracing";
    public static final String INJECT_CALLER_ID = "injectCallerId";
    public static final String ENABLE_HTTP_2 = "enableHttp2";
    public static final String CONNECTION_POOL_SIZE = "connectionPoolSize";
    public static final String CONNECTION_EXPIRE_TIME = "connectionExpireTime";
    public static final String MAX_REQ_PER_CONN = "maxReqPerConn";
    public static final String MAX_CONNECTION_NUM_PER_HOST = "maxConnectionNumPerHost";
    public static final String MIN_CONNECTION_NUM_PER_HOST = "minConnectionNumPerHost";
    public static final String MAX_REQUEST_RETRY = "maxRequestRetry";
    public static final String REQUEST_RETRY_DELAY = "requestRetryDelay";
    @IntegerField(configFieldName="errorThreshold", externalizedKeyName="errorThreshold", externalized=true, defaultValue=2, description="number of timeouts/errors to break the circuit")
    private int errorThreshold;
    @IntegerField(configFieldName="timeout", externalizedKeyName="timeout", externalized=true, defaultValue=3000, description="timeout in millisecond to indicate a client error. If light-4j Http2Client is used, it is the timeout to get the\nconnection. If http-client (JDK 11 client wrapper) is used, it is the request timeout. The default value is 3000.")
    private int timeout;
    @IntegerField(configFieldName="resetTimeout", externalizedKeyName="resetTimeout", externalized=true, defaultValue=7000, description="reset the circuit after this timeout in millisecond")
    private int resetTimeout;
    @BooleanField(configFieldName="injectOpenTracing", externalizedKeyName="injectOpenTracing", externalized=true, description="if open tracing is enabled. traceability, correlation and metrics should not be in the chain if opentracing is used.")
    private boolean injectOpenTracing;
    @BooleanField(configFieldName="injectCallerId", externalizedKeyName="injectCallerId", externalized=true, description="inject serviceId as callerId into the http header for metrics to collect the caller. The serviceId is from server.yml")
    private boolean injectCallerId;
    @BooleanField(configFieldName="enableHttp2", externalizedKeyName="enableHttp2", externalized=true, defaultValue=true, description="the flag to indicate whether http/2 is enabled when calling client.callService()")
    private boolean enableHttp2;
    @IntegerField(configFieldName="connectionPoolSize", externalizedKeyName="connectionPoolSize", externalized=true, defaultValue=1000, description="the maximum host capacity of connection pool")
    private int connectionPoolSize;
    @IntegerField(configFieldName="connectionExpireTime", externalizedKeyName="connectionExpireTime", externalized=true, defaultValue=1800000, description="Connection expire time when connection pool is used. By default, the cached connection will be closed after 30 minutes.\nThis is one way to force the connection to be closed so that the client-side discovery can be balanced.")
    private int connectionExpireTime;
    @IntegerField(configFieldName="maxReqPerConn", externalizedKeyName="maxReqPerConn", externalized=true, defaultValue=1000000, description="The maximum request limitation for each connection in the connection pool. By default, a connection will be closed after\nsending 1 million requests. This is one way to force the client-side discovery to re-balance the connections.")
    private int maxReqPerConn;
    @IntegerField(configFieldName="maxConnectionNumPerHost", externalizedKeyName="maxConnectionNumPerHost", externalized=true, defaultValue=1000, description="maximum quantity of connection in connection pool for each host")
    private int maxConnectionNumPerHost;
    @IntegerField(configFieldName="minConnectionNumPerHost", externalizedKeyName="minConnectionNumPerHost", externalized=true, defaultValue=250, description="minimum quantity of connection in connection pool for each host. The corresponding connection number will shrink to minConnectionNumPerHost\nby remove least recently used connections when the connection number of a host reach 0.75 * maxConnectionNumPerHost.")
    private int minConnectionNumPerHost;
    @IntegerField(configFieldName="maxRequestRetry", externalizedKeyName="maxRequestRetry", externalized=true, defaultValue=3, description="Maximum request retry times for each request. If you don't want to retry, set it to 1. The default value is 3.")
    private int maxRequestRetry;
    @IntegerField(configFieldName="requestRetryDelay", externalizedKeyName="requestRetryDelay", externalized=true, defaultValue=1000, description="The delay time in milliseconds for each request retry. The default value is 1000.")
    private int requestRetryDelay;

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResetTimeout() {
        return this.resetTimeout;
    }

    public boolean isInjectOpenTracing() {
        return this.injectOpenTracing;
    }

    public boolean isInjectCallerId() {
        return this.injectCallerId;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setIsEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getConnectionExpireTime() {
        return this.connectionExpireTime;
    }

    public int getMaxReqPerConn() {
        return this.maxReqPerConn;
    }

    public int getMaxConnectionNumPerHost() {
        return this.maxConnectionNumPerHost;
    }

    public int getMinConnectionNumPerHost() {
        return this.minConnectionNumPerHost;
    }

    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    public int getRequestRetryDelay() {
        return this.requestRetryDelay;
    }
}

