/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.AuthServerConfig;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.StringField;
import java.util.Map;

public class OAuthTokenKeyConfig {
    public static final String SERVER_URL = "server_url";
    public static final String SERVICE_ID = "serviceId";
    public static final String URI = "uri";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String ENABLE_HTTP_2 = "enableHttp2";
    public static final String SERVICE_ID_AUTH_SERVERS = "serviceIdAuthServers";
    public static final String AUDIENCE = "audience";
    @StringField(configFieldName="server_url", externalizedKeyName="tokenKeyServerUrl", externalized=true, description="key distribution server url for token verification. It will be used if it is configured.\nIf it is not set, a service lookup will be taken with serviceId to find an instance")
    private String server_url;
    @StringField(configFieldName="serviceId", externalizedKeyName="tokenKeyServiceId", externalized=true, defaultValue="com.networknt.oauth2-key-1.0.0", description="key serviceId for key distribution service, it will be used if above server_url is not configured.")
    private String serviceId;
    @StringField(configFieldName="uri", externalizedKeyName="tokenKeyUri", externalized=true, defaultValue="/oauth2/key", description="the path for the key distribution endpoint")
    private String uri;
    @StringField(configFieldName="client_id", externalizedKeyName="tokenKeyClientId", externalized=true, defaultValue="f7d42348-c647-4efb-a52d-4c5787421e72", description="client_id used to access key distribution service. It can be the same client_id with token service or not.")
    private char[] client_id;
    @StringField(configFieldName="client_secret", externalizedKeyName="tokenKeyClientSecret", externalized=true, defaultValue="f6h1FTI8Q3-7UScPZDzfXA", description="client secret used to access the key distribution service.")
    private char[] client_secret;
    @BooleanField(configFieldName="enableHttp2", externalizedKeyName="tokenKeyEnableHttp2", defaultValue=true, externalized=true, description="set to true if the oauth2 provider supports HTTP/2")
    private boolean enableHttp2;
    @MapField(configFieldName="serviceIdAuthServers", externalizedKeyName="tokenKeyServiceIdAuthServers", valueType=AuthServerConfig.class, externalized=true, description="The serviceId to the service specific OAuth 2.0 configuration. Used only when multipleOAuthServer is\nset as true. For detailed config options, please see the values.yml in the client module test.")
    private Map<String, AuthServerConfig> serviceIdAuthServers;
    @StringField(configFieldName="audience", externalizedKeyName="tokenKeyAudience", externalized=true, description="audience for the token validation. It is optional and if it is not configured, no audience validation will be executed.")
    private String audience;

    public String getServer_url() {
        return this.server_url;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getUri() {
        return this.uri;
    }

    public char[] getClient_id() {
        return this.client_id;
    }

    public char[] getClient_secret() {
        return this.client_secret;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public Map<String, AuthServerConfig> getServiceIdAuthServers() {
        return this.serviceIdAuthServers;
    }

    public String getAudience() {
        return this.audience;
    }
}

