/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.cache.CacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheManager
implements CacheManager {
    private final Map<String, Cache<Object, Object>> caches = new ConcurrentHashMap<String, Cache<Object, Object>>();

    public CaffeineCacheManager() {
        if (logger.isInfoEnabled()) {
            logger.info("CaffeineCacheManager is constructed.");
        }
    }

    @Override
    public void addCache(String cacheName, long maximumSize, long expiryInMinutes) {
        Cache cache = Caffeine.newBuilder().maximumSize(maximumSize).expireAfterWrite(expiryInMinutes, TimeUnit.MINUTES).build();
        this.caches.put(cacheName, cache);
    }

    @Override
    public Map<Object, Object> getCache(String cacheName) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            return cache.asMap();
        }
        return null;
    }

    @Override
    public void put(String cacheName, String key, Object value) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            cache.put(key, value);
        }
    }

    @Override
    public Object get(String cacheName, String key) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            return cache.getIfPresent(key);
        }
        return null;
    }

    @Override
    public void delete(String cacheName, String key) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            cache.invalidate(key);
        }
    }

    @Override
    public void removeCache(String cacheName) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            cache.invalidateAll();
            this.caches.remove(cacheName);
        }
    }

    @Override
    public int getSize(String cacheName) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            return (int)cache.estimatedSize();
        }
        return 0;
    }
}

