/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.body.BodyConverter;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BodyHandler.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final AttachmentKey<Object> REQUEST_BODY = AttachmentConstants.REQUEST_BODY;
    public static final AttachmentKey<String> REQUEST_BODY_STRING = AttachmentConstants.REQUEST_BODY_STRING;
    public static BodyConfig config;
    private volatile HttpHandler next;

    public BodyHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("BodyHandler is loaded.");
        }
        config = BodyConfig.load();
    }

    public BodyHandler(String configName) {
        if (logger.isInfoEnabled()) {
            logger.info("BodyHandler is loaded.");
        }
        config = BodyConfig.load(configName);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String contentType;
        if (logger.isDebugEnabled()) {
            logger.debug("BodyHandler.handleRequest starts.");
        }
        if ((contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE)) != null) {
            if (exchange.isInIoThread()) {
                exchange.dispatch(this);
                return;
            }
            exchange.startBlocking();
            try {
                if (contentType.startsWith("application/json")) {
                    boolean res;
                    InputStream inputStream2 = exchange.getInputStream();
                    String unparsedRequestBody = StringUtils.inputStreamToString(inputStream2, StandardCharsets.UTF_8);
                    if (config.isCacheRequestBody()) {
                        exchange.putAttachment(AttachmentConstants.REQUEST_BODY_STRING, unparsedRequestBody);
                    }
                    if (!(res = this.attachJsonBody(exchange, unparsedRequestBody))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("BodyHandler.handleRequest ends with an error.");
                        }
                        return;
                    }
                } else if (contentType.startsWith("text/plain")) {
                    InputStream inputStream3 = exchange.getInputStream();
                    String unparsedRequestBody = StringUtils.inputStreamToString(inputStream3, StandardCharsets.UTF_8);
                    exchange.putAttachment(AttachmentConstants.REQUEST_BODY, unparsedRequestBody);
                } else if (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded")) {
                    this.attachFormDataBody(exchange);
                } else {
                    InputStream inputStream4 = exchange.getInputStream();
                    exchange.putAttachment(AttachmentConstants.REQUEST_BODY, inputStream4);
                }
            }
            catch (IOException e) {
                logger.error("IOException: ", e);
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, contentType);
                if (logger.isDebugEnabled()) {
                    logger.debug("BodyHandler.handleRequest ends with an error.");
                }
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("BodyHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    private void attachFormDataBody(HttpServerExchange exchange) throws IOException {
        FormParserFactory formParserFactory = FormParserFactory.builder().build();
        FormDataParser parser = formParserFactory.createParser(exchange);
        if (parser != null) {
            FormData formData = parser.parseBlocking();
            Map<String, Object> data = BodyConverter.convert(formData);
            exchange.putAttachment(AttachmentConstants.REQUEST_BODY, data);
        } else {
            InputStream inputStream2 = exchange.getInputStream();
            exchange.putAttachment(AttachmentConstants.REQUEST_BODY, inputStream2);
        }
    }

    private boolean attachJsonBody(HttpServerExchange exchange, String string) throws IOException {
        if (string != null) {
            Object body;
            if ((string = string.trim()).startsWith("{")) {
                body = Config.getInstance().getMapper().readValue(string, new TypeReference<Map<String, Object>>(){});
            } else if (string.startsWith("[")) {
                body = Config.getInstance().getMapper().readValue(string, new TypeReference<List<Object>>(){});
            } else {
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
                return false;
            }
            exchange.putAttachment(AttachmentConstants.REQUEST_BODY, body);
        }
        return true;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("body", BodyHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("body"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("body", BodyHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("body"), null);
        if (logger.isInfoEnabled()) {
            logger.info("BodyHandler is reloaded.");
        }
    }
}

