/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="body", configName="body", configDescription="The config for the body handler.", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class BodyConfig {
    private static final Logger logger = LoggerFactory.getLogger(BodyConfig.class);
    public static final String CONFIG_NAME = "body";
    private static final String ENABLED = "enabled";
    private static final String CACHE_REQUEST_BODY = "cacheRequestBody";
    private static final String CACHE_RESPONSE_BODY = "cacheResponseBody";
    private static final String LOG_FULL_REQUEST_BODY = "logFullRequestBody";
    private static final String LOG_FULL_RESPONSE_BODY = "logFullResponseBody";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", description="Enable body parse flag", externalized=true, defaultValue=true)
    boolean enabled;
    @BooleanField(configFieldName="cacheRequestBody", externalizedKeyName="cacheRequestBody", externalized=true, description="cache request body as a string along with JSON object. The string formatted request body will be used for audit log.\nyou should only enable this if you have configured audit.yml to log the request body as it uses extra memory.")
    boolean cacheRequestBody;
    @BooleanField(configFieldName="logFullRequestBody", externalizedKeyName="logFullRequestBody", externalized=true, description="log the full request body when RequestBodyInterceptor is enabled. This is useful for troubleshooting but not recommended\nfor production. The default value is false and only 16K of the request body will be logged.")
    boolean logFullRequestBody;
    @BooleanField(configFieldName="cacheResponseBody", externalizedKeyName="cacheResponseBody", externalized=true, description="cache response body as a string along with JSON object. The string formatted response body will be used for audit log.\nyou should only enable this if you have configured audit.yml to log the response body as it uses extra memory.")
    boolean cacheResponseBody;
    @BooleanField(configFieldName="logFullResponseBody", externalizedKeyName="logFullResponseBody", externalized=true, description="log the full response body when ResponseBodyInterceptor is enabled. This is useful for troubleshooting but not recommended\nfor production. The default value is false and only 16K of the response body will be logged.")
    boolean logFullResponseBody;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public BodyConfig() {
        this(CONFIG_NAME);
    }

    private BodyConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static BodyConfig load() {
        return new BodyConfig();
    }

    public static BodyConfig load(String configName) {
        return new BodyConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCacheRequestBody() {
        return this.cacheRequestBody;
    }

    public boolean isCacheResponseBody() {
        return this.cacheResponseBody;
    }

    public boolean isLogFullRequestBody() {
        return this.logFullRequestBody;
    }

    public boolean isLogFullResponseBody() {
        return this.logFullResponseBody;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(CACHE_REQUEST_BODY)) != null) {
            this.cacheRequestBody = Config.loadBooleanValue(CACHE_REQUEST_BODY, object);
        }
        if ((object = this.mappedConfig.get(CACHE_RESPONSE_BODY)) != null) {
            this.cacheResponseBody = Config.loadBooleanValue(CACHE_RESPONSE_BODY, object);
        }
        if ((object = this.mappedConfig.get(LOG_FULL_REQUEST_BODY)) != null) {
            this.logFullRequestBody = Config.loadBooleanValue(LOG_FULL_REQUEST_BODY, object);
        }
        if ((object = this.mappedConfig.get(LOG_FULL_RESPONSE_BODY)) != null) {
            this.logFullResponseBody = Config.loadBooleanValue(LOG_FULL_RESPONSE_BODY, object);
        }
    }
}

