/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kjetland.jackson.jsonSchema.DefinitionsHandler;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.JsonSchemaGeneratorVisitor;
import com.kjetland.jackson.jsonSchema.Utils;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaBool;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaFormat;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInt;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaString;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaGenerator {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaGenerator.class);
    final ObjectMapper objectMapper;
    final JsonSchemaConfig config;

    public JsonSchemaGenerator(ObjectMapper rootObjectMapper) {
        this(rootObjectMapper, JsonSchemaConfig.DEFAULT);
    }

    public JsonSchemaGenerator(ObjectMapper rootObjectMapper, JsonSchemaConfig config) {
        this.objectMapper = rootObjectMapper;
        this.config = config;
    }

    public JsonNode generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        return this.generateJsonSchema(clazz, null, null);
    }

    public JsonNode generateJsonSchema(JavaType javaType) throws JsonMappingException {
        return this.generateJsonSchema(javaType, null, null);
    }

    public JsonNode generateJsonSchema(Class<?> clazz, String title, String description) throws JsonMappingException {
        Class<?> clazzToUse = this.tryToReMapType(clazz);
        JavaType javaType = this.objectMapper.constructType(clazzToUse);
        return this.generateJsonSchema(javaType, title, description);
    }

    public JsonNode generateJsonSchema(JavaType javaType, String title, String description) throws JsonMappingException {
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        rootNode.put("$schema", this.config.jsonSchemaDraft.url);
        if (title == null) {
            title = Utils.camelCaseToSentenceCase(javaType.getRawClass().getSimpleName());
        }
        if (!title.isEmpty()) {
            rootNode.put("title", title);
        }
        if (description != null) {
            rootNode.put("description", description);
        }
        DefinitionsHandler definitionsHandler = new DefinitionsHandler(this.config);
        JsonSchemaGeneratorVisitor rootVisitor = new JsonSchemaGeneratorVisitor(this, 0, rootNode, definitionsHandler, null);
        this.objectMapper.acceptJsonFormatVisitor(javaType, (JsonFormatVisitorWrapper)rootVisitor);
        ObjectNode definitionsNode = definitionsHandler.getFinalDefinitionsNode();
        if (definitionsNode != null) {
            rootNode.set("definitions", definitionsNode);
        }
        return rootNode;
    }

    JavaType tryToReMapType(JavaType originalType) {
        Class<?> mappedToClass = this.config.classTypeReMapping.get(originalType.getRawClass());
        if (mappedToClass != null) {
            log.trace("Class {} is remapped to {}", (Object)originalType, (Object)mappedToClass);
            return this.objectMapper.getTypeFactory().constructType(mappedToClass);
        }
        return originalType;
    }

    Class<?> tryToReMapType(Class<?> originalClass) {
        Class<?> mappedToClass = this.config.classTypeReMapping.get(originalClass);
        if (mappedToClass != null) {
            log.trace("Class {} is remapped to {}", (Object)originalClass, (Object)mappedToClass);
            return mappedToClass;
        }
        return originalClass;
    }

    String resolvePropertyFormat(JavaType type) {
        DeserializationConfig omConfig = this.objectMapper.getDeserializationConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolve(omConfig, type, omConfig);
        JsonSchemaFormat annotation = annotatedClass.getAnnotation(JsonSchemaFormat.class);
        if (annotation != null) {
            return annotation.value();
        }
        String rawClassName = type.getRawClass().getName();
        return this.config.customType2FormatMapping.get(rawClassName);
    }

    String resolvePropertyFormat(BeanProperty prop) {
        JsonSchemaFormat annotation = prop.getAnnotation(JsonSchemaFormat.class);
        if (annotation != null) {
            return annotation.value();
        }
        String rawClassName = prop.getType().getRawClass().getName();
        return this.config.customType2FormatMapping.get(rawClassName);
    }

    <T extends Annotation> T selectAnnotation(BeanProperty prop, Class<T> annotationClass) {
        if (prop == null) {
            return null;
        }
        T ann = prop.getAnnotation(annotationClass);
        if (ann == null || !this.annotationIsApplicable((Annotation)ann)) {
            return null;
        }
        return ann;
    }

    <T extends Annotation> T selectAnnotation(AnnotatedClass annotatedClass, Class<T> annotationClass) {
        T ann = annotatedClass.getAnnotation(annotationClass);
        if (ann == null || !this.annotationIsApplicable((Annotation)ann)) {
            return null;
        }
        return ann;
    }

    boolean validationAnnotationRequired(BeanProperty prop) {
        return this.selectAnnotation(prop, NotNull.class) != null || this.selectAnnotation(prop, NotBlank.class) != null || this.selectAnnotation(prop, NotEmpty.class) != null;
    }

    public boolean hasNullableAnnotation(BeanProperty prop) {
        AnnotationMap annotations2 = prop.getMember().getAllAnnotations();
        for (Annotation annotation : annotations2.annotations()) {
            String annotationType = annotation.annotationType().getSimpleName();
            if (!annotationType.equals("Nullable")) continue;
            return true;
        }
        return false;
    }

    public boolean hasNotNullAnnotation(BeanProperty prop) {
        AnnotationMap annotations2 = prop.getMember().getAllAnnotations();
        for (Annotation annotation : annotations2.annotations()) {
            String annotationType = annotation.annotationType().getSimpleName();
            if (!annotationType.equals("NonNull") && !annotationType.equals("Nonnull") && !annotationType.equals("NotNull") && this.selectAnnotation(prop, NotBlank.class) == null && this.selectAnnotation(prop, NotEmpty.class) == null) continue;
            return true;
        }
        return false;
    }

    boolean annotationIsApplicable(Annotation annotation) {
        List<Class<?>> annotationGroups;
        List<Class<?>> desiredGroups = this.config.javaxValidationGroups;
        if (desiredGroups == null || desiredGroups.isEmpty()) {
            desiredGroups = Collections.unmodifiableList(Arrays.asList(Default.class));
        }
        if ((annotationGroups = Utils.extractGroupsFromAnnotation(annotation)).isEmpty()) {
            annotationGroups = Collections.unmodifiableList(Arrays.asList(Default.class));
        }
        for (Class<?> group : annotationGroups) {
            if (!desiredGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    TypeSerializer getTypeSerializer(JavaType baseType) throws JsonMappingException {
        return this.objectMapper.getSerializerFactory().createTypeSerializer(this.objectMapper.getSerializationConfig(), baseType);
    }

    boolean injectFromAnnotation(ObjectNode node, JsonSchemaInject injectAnnotation) throws JsonMappingException {
        JsonNode jsonNode;
        Object jsonSupplier;
        JsonNode injectedNode;
        try {
            injectedNode = this.objectMapper.readTree(injectAnnotation.json());
        }
        catch (JsonProcessingException e) {
            throw new JsonMappingException("Could not parse JsonSchemaInject.json", e);
        }
        try {
            jsonSupplier = injectAnnotation.jsonSupplier().newInstance();
            jsonNode = jsonSupplier.get();
            if (jsonNode != null) {
                Utils.merge(injectedNode, jsonNode);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JsonMappingException("Could not call JsonSchemaInject.jsonSupplier constructor", e);
        }
        if (!injectAnnotation.jsonSupplierViaLookup().isEmpty()) {
            jsonSupplier = this.config.jsonSuppliers.get(injectAnnotation.jsonSupplierViaLookup());
            if (jsonSupplier == null) {
                throw new JsonMappingException("@JsonSchemaInject(jsonSupplierLookup='" + injectAnnotation.jsonSupplierViaLookup() + "') does not exist in ctx.config.jsonSupplierLookup-map");
            }
            jsonNode = (JsonNode)jsonSupplier.get();
            if (jsonNode != null) {
                Utils.merge(injectedNode, jsonNode);
            }
        }
        for (JsonSchemaString jsonSchemaString : injectAnnotation.strings()) {
            Utils.visit(injectedNode, jsonSchemaString.path(), (o, n) -> o.put((String)n, jsonSchemaString.value()));
        }
        for (JsonSchemaInt jsonSchemaInt : injectAnnotation.ints()) {
            Utils.visit(injectedNode, jsonSchemaInt.path(), (o, n) -> o.put((String)n, jsonSchemaInt.value()));
        }
        for (JsonSchemaBool jsonSchemaBool : injectAnnotation.bools()) {
            Utils.visit(injectedNode, jsonSchemaBool.path(), (o, n) -> o.put((String)n, jsonSchemaBool.value()));
        }
        boolean injectOverridesAll = injectAnnotation.overrideAll();
        if (injectOverridesAll) {
            node.removeAll();
        }
        Utils.merge(node, injectedNode);
        return injectOverridesAll;
    }
}

