/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.internal;

import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import com.github.f4b6a3.uuid.util.internal.SettingsUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public final class RandomUtil {
    private RandomUtil() {
    }

    public static long nextLong() {
        return SecureRandomPool.nextLong();
    }

    public static byte[] nextBytes(int length) {
        return SecureRandomPool.nextBytes(length);
    }

    public static SecureRandom newSecureRandom() {
        String algorithm = SettingsUtil.getSecureRandom();
        if (algorithm != null) {
            try {
                return SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                return new SecureRandom();
            }
        }
        return new SecureRandom();
    }

    private static class SecureRandomPool {
        private static final Random random = new Random();
        private static final int POOL_SIZE = SecureRandomPool.processors();
        private static final Random[] POOL = new Random[POOL_SIZE];
        private static final ReentrantLock lock = new ReentrantLock();

        private SecureRandomPool() {
        }

        public static long nextLong() {
            return ByteUtil.toNumber(SecureRandomPool.nextBytes(8));
        }

        public static byte[] nextBytes(int length) {
            byte[] bytes = new byte[length];
            SecureRandomPool.current().nextBytes(bytes);
            if (bytes.length > 0 && bytes[0] == 0) {
                SecureRandomPool.delete(random.nextInt(POOL_SIZE));
            }
            return bytes;
        }

        private static Random current() {
            int index = (int)Thread.currentThread().getId() % POOL_SIZE;
            lock.lock();
            try {
                if (POOL[index] == null) {
                    SecureRandomPool.POOL[index] = RandomUtil.newSecureRandom();
                }
                Random random = POOL[index];
                return random;
            }
            finally {
                lock.unlock();
            }
        }

        private static void delete(int index) {
            lock.lock();
            try {
                SecureRandomPool.POOL[index] = null;
            }
            finally {
                lock.unlock();
            }
        }

        private static int processors() {
            int min2 = 4;
            int max = 32;
            int processors = Runtime.getRuntime().availableProcessors();
            if (processors < 4) {
                return 4;
            }
            if (processors > 32) {
                return 32;
            }
            return processors;
        }
    }
}

