/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.internal;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static long toNumber(byte[] bytes) {
        return ByteUtil.toNumber(bytes, 0, bytes.length);
    }

    public static long toNumber(byte[] bytes, int start, int end) {
        long result2 = 0L;
        for (int i = start; i < end; ++i) {
            result2 = result2 << 8 | (long)bytes[i] & 0xFFL;
        }
        return result2;
    }

    public static String toHexadecimal(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            chars[j] = ByteUtil.toHexChar(v >>> 4);
            chars[j + 1] = ByteUtil.toHexChar(v & 0xF);
            ++i;
            j += 2;
        }
        return new String(chars);
    }

    private static char toHexChar(int number) {
        if (number >= 0 && number <= 9) {
            return (char)(48 + number);
        }
        if (number >= 10 && number <= 15) {
            return (char)(87 + number);
        }
        return '\u0000';
    }

    public static int[] toInts(byte[] bytes) {
        int[] ints = new int[4];
        ints[0] = ints[0] | (bytes[0] & 0xFF) << 24;
        ints[0] = ints[0] | (bytes[1] & 0xFF) << 16;
        ints[0] = ints[0] | (bytes[2] & 0xFF) << 8;
        ints[0] = ints[0] | bytes[3] & 0xFF;
        ints[1] = ints[1] | (bytes[4] & 0xFF) << 24;
        ints[1] = ints[1] | (bytes[5] & 0xFF) << 16;
        ints[1] = ints[1] | (bytes[6] & 0xFF) << 8;
        ints[1] = ints[1] | bytes[7] & 0xFF;
        ints[2] = ints[2] | (bytes[8] & 0xFF) << 24;
        ints[2] = ints[2] | (bytes[9] & 0xFF) << 16;
        ints[2] = ints[2] | (bytes[10] & 0xFF) << 8;
        ints[2] = ints[2] | bytes[11] & 0xFF;
        ints[3] = ints[3] | (bytes[12] & 0xFF) << 24;
        ints[3] = ints[3] | (bytes[13] & 0xFF) << 16;
        ints[3] = ints[3] | (bytes[14] & 0xFF) << 8;
        ints[3] = ints[3] | bytes[15] & 0xFF;
        return ints;
    }

    public static byte[] fromInts(int[] ints) {
        byte[] bytes = new byte[]{(byte)(ints[0] >>> 24), (byte)(ints[0] >>> 16), (byte)(ints[0] >>> 8), (byte)ints[0], (byte)(ints[1] >>> 24), (byte)(ints[1] >>> 16), (byte)(ints[1] >>> 8), (byte)ints[1], (byte)(ints[2] >>> 24), (byte)(ints[2] >>> 16), (byte)(ints[2] >>> 8), (byte)ints[2], (byte)(ints[3] >>> 24), (byte)(ints[3] >>> 16), (byte)(ints[3] >>> 8), (byte)ints[3]};
        return bytes;
    }
}

