/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import java.util.UUID;

public final class BaseNRemainderDecoder
extends BaseNDecoder {
    private final int multiplier;
    private static final long MASK = 0xFFFFFFFFL;

    public BaseNRemainderDecoder(BaseN base2) {
        super(base2);
        this.multiplier = base2.getRadix();
    }

    @Override
    public UUID apply(String string) {
        long msb = 0L;
        long lsb = 0L;
        long rem = 0L;
        for (int i = 0; i < this.base.getLength(); ++i) {
            rem = this.get(string, i);
            long[] ans = BaseNRemainderDecoder.multiply(lsb, this.multiplier, rem);
            lsb = ans[0];
            rem = ans[1];
            ans = BaseNRemainderDecoder.multiply(msb, this.multiplier, rem);
            msb = ans[0];
            rem = ans[1];
        }
        if (rem != 0L) {
            throw new InvalidUuidException("Invalid encoded string (overflow): \"" + string + "\"");
        }
        return new UUID(msb, lsb);
    }

    protected static long[] multiply(long x, long multiplier, long rem) {
        long mul = (x & 0xFFFFFFFFL) * multiplier + rem;
        long product1 = mul & 0xFFFFFFFFL;
        long overflow = mul >>> 32;
        mul = (x >>> 32) * multiplier + overflow;
        long product2 = mul & 0xFFFFFFFFL;
        overflow = mul >>> 32;
        long[] answer = new long[]{product2 << 32 | product1 & 0xFFFFFFFFL, overflow};
        return answer;
    }
}

