/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNRemainderDecoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNRemainderEncoder;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;
import java.util.function.Function;

public abstract class BaseNCodec
implements UuidCodec<String> {
    protected final BaseN base;
    protected final Function<UUID, String> encoder;
    protected final Function<String, UUID> decoder;

    protected BaseNCodec(BaseN base2) {
        this(base2, null);
    }

    protected BaseNCodec(BaseN base2, CustomDivider divider) {
        this(base2, new BaseNRemainderEncoder(base2, divider), new BaseNRemainderDecoder(base2));
    }

    protected BaseNCodec(BaseN base2, BaseNEncoder encoder, BaseNDecoder decoder) {
        this.base = base2;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public static BaseNCodec newInstance(BaseN base2) {
        return BaseNCodec.newInstance(base2, null);
    }

    public static BaseNCodec newInstance(int radix) {
        return BaseNCodec.newInstance(radix, null);
    }

    public static BaseNCodec newInstance(String alphabet) {
        return BaseNCodec.newInstance(alphabet, null);
    }

    public static BaseNCodec newInstance(BaseN base2, CustomDivider divider) {
        return new BaseNCodec(base2, divider){};
    }

    public static BaseNCodec newInstance(int radix, CustomDivider divider) {
        BaseN base2 = new BaseN(radix);
        return BaseNCodec.newInstance(base2, divider);
    }

    public static BaseNCodec newInstance(String alphabet, CustomDivider divider) {
        BaseN base2 = new BaseN(alphabet);
        return BaseNCodec.newInstance(base2, divider);
    }

    public BaseN getBase() {
        return this.base;
    }

    @Override
    public String encode(UUID uuid) {
        try {
            UuidValidator.validate(uuid);
            return this.encoder.apply(uuid);
        }
        catch (RuntimeException e) {
            throw new InvalidUuidException(e.getMessage(), e);
        }
    }

    @Override
    public UUID decode(String string) {
        try {
            this.validate(string);
            return this.decoder.apply(string);
        }
        catch (RuntimeException e) {
            throw new InvalidUuidException(e.getMessage(), e);
        }
    }

    protected void validate(String string) {
        if (string == null || string.length() != this.base.getLength()) {
            throw InvalidUuidException.newInstance(string);
        }
    }

    @FunctionalInterface
    public static interface CustomDivider {
        public long[] divide(long var1);
    }
}

