/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.alt;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongSupplier;

public final class GUID
implements Serializable,
Comparable<GUID> {
    private static final long serialVersionUID = -6082258105369032877L;
    private final long msb;
    private final long lsb;
    public static final GUID NIL = new GUID(0L, 0L);
    public static final GUID MAX = new GUID(-1L, -1L);
    public static final GUID NAMESPACE_DNS = new GUID(7757371264673321425L, -9172705715073830712L);
    public static final GUID NAMESPACE_URL = new GUID(7757371268968288721L, -9172705715073830712L);
    public static final GUID NAMESPACE_OID = new GUID(7757371273263256017L, -9172705715073830712L);
    public static final GUID NAMESPACE_X500 = new GUID(7757371281853190609L, -9172705715073830712L);
    public static final byte LOCAL_DOMAIN_PERSON = 0;
    public static final byte LOCAL_DOMAIN_GROUP = 1;
    public static final byte LOCAL_DOMAIN_ORG = 2;
    public static final int GUID_CHARS = 36;
    public static final int GUID_BYTES = 16;
    private static final long MASK_08 = 255L;
    private static final long MASK_12 = 4095L;
    private static final long MASK_16 = 65535L;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final long MULTICAST = 0x10000000000L;

    public GUID(GUID guid) {
        if (guid == null) {
            throw new IllegalArgumentException("Null GUID");
        }
        this.msb = guid.msb;
        this.lsb = guid.lsb;
    }

    public GUID(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Null UUID");
        }
        this.msb = uuid.getMostSignificantBits();
        this.lsb = uuid.getLeastSignificantBits();
    }

    public GUID(long mostSignificantBits, long leastSignificantBits) {
        this.msb = mostSignificantBits;
        this.lsb = leastSignificantBits;
    }

    public GUID(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Invalid GUID bytes");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.msb = buffer.getLong();
        this.lsb = buffer.getLong();
    }

    public GUID(String string) {
        this(Parser.parse(string));
    }

    public static GUID v1() {
        return GUID.v1(System::currentTimeMillis, () -> TLRandom.nextLong());
    }

    public static GUID v1(Instant instant, Random random) {
        return GUID.v1(GUID.optional(instant), GUID.optional(random));
    }

    private static GUID v1(LongSupplier msec, LongSupplier random) {
        long time = GUID.gregorian(msec.getAsLong());
        long msb = time << 32 | time >>> 16 & 0xFFFF0000L | time >>> 48 & 0xFFFL;
        long lsb = random.getAsLong() | 0x10000000000L;
        return GUID.version(msb, lsb, 1);
    }

    public static GUID v2(byte localDomain, int localIdentifier) {
        return GUID.v2(localDomain, localIdentifier, GUID.v1());
    }

    public static GUID v2(byte localDomain, int localIdentifier, Instant instant, Random random) {
        return GUID.v2(localDomain, localIdentifier, GUID.v1(instant, random));
    }

    private static GUID v2(byte localDomain, int localIdentifier, GUID guid) {
        long msb = guid.msb & 0xFFFFFFFFL | ((long)localIdentifier & 0xFFFFFFFFL) << 32;
        long lsb = guid.lsb & 0x3F00FFFFFFFFFFFFL | ((long)localDomain & 0xFFL) << 48;
        return GUID.version(msb, lsb, 2);
    }

    public static GUID v3(GUID namespace, String name2) {
        return GUID.hash(3, "MD5", namespace, name2);
    }

    public static GUID v3(GUID namespace, byte[] bytes) {
        return GUID.hash(3, "MD5", namespace, bytes);
    }

    public static GUID v4() {
        return GUID.version(TLRandom.nextLong(), TLRandom.nextLong(), 4);
    }

    public static GUID v4(Random random) {
        Objects.requireNonNull(random, "Null random");
        return GUID.version(random.nextLong(), random.nextLong(), 4);
    }

    public static GUID v5(GUID namespace, String name2) {
        return GUID.hash(5, "SHA-1", namespace, name2);
    }

    public static GUID v5(GUID namespace, byte[] bytes) {
        return GUID.hash(5, "SHA-1", namespace, bytes);
    }

    public static GUID v6() {
        return GUID.v6(System::currentTimeMillis, () -> TLRandom.nextLong());
    }

    public static GUID v6(Instant instant, Random random) {
        return GUID.v6(GUID.optional(instant), GUID.optional(random));
    }

    private static GUID v6(LongSupplier msec, LongSupplier random) {
        long time = GUID.gregorian(msec.getAsLong());
        long msb = (time & 0xFFFFFFFFFFFFF000L) << 4 | time & 0xFFFL;
        long lsb = random.getAsLong() | 0x10000000000L;
        return GUID.version(msb, lsb, 6);
    }

    public static GUID v7() {
        return GUID.v7(System::currentTimeMillis, () -> TLRandom.nextLong());
    }

    public static GUID v7(Instant instant, Random random) {
        return GUID.v7(GUID.optional(instant), GUID.optional(random));
    }

    private static GUID v7(LongSupplier msec, LongSupplier random) {
        long time = msec.getAsLong();
        long msb = time << 16 | TLRandom.nextLong() & 0xFFFL;
        long lsb = random.getAsLong();
        return GUID.version(msb, lsb, 7);
    }

    public static boolean valid(String string) {
        return Parser.valid(string);
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(16).putLong(this.msb).putLong(this.lsb).array();
    }

    public String toString() {
        return this.toUUID().toString();
    }

    public UUID toUUID() {
        return new UUID(this.msb, this.lsb);
    }

    public int version() {
        return this.toUUID().version();
    }

    public int hashCode() {
        long bits = this.msb ^ this.lsb;
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != GUID.class) {
            return false;
        }
        GUID that = (GUID)other;
        if (this.lsb != that.lsb) {
            return false;
        }
        return this.msb == that.msb;
    }

    @Override
    public int compareTo(GUID other) {
        GUID that = other != null ? other : NIL;
        long min2 = Long.MIN_VALUE;
        long a = this.msb + Long.MIN_VALUE;
        long b = that.msb + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        long c = this.lsb + Long.MIN_VALUE;
        long d = that.lsb + Long.MIN_VALUE;
        if (c > d) {
            return 1;
        }
        if (c < d) {
            return -1;
        }
        return 0;
    }

    static LongSupplier optional(Instant instant) {
        return instant == null ? System::currentTimeMillis : instant::toEpochMilli;
    }

    static LongSupplier optional(Random random) {
        return random == null ? () -> TLRandom.nextLong() : random::nextLong;
    }

    static long gregorian(long millisecons) {
        long factor = 10000L;
        long offset = 12219292800000L;
        return (millisecons + 12219292800000L) * 10000L;
    }

    static GUID hash(int version, String algorithm, GUID namespace, String name2) {
        Objects.requireNonNull(name2, "Null name");
        return GUID.hash(version, algorithm, namespace, name2.getBytes(StandardCharsets.UTF_8));
    }

    static GUID hash(int version, String algorithm, GUID namespace, byte[] bytes) {
        Objects.requireNonNull(bytes, "Null bytes");
        MessageDigest hasher = GUID.hasher(algorithm);
        if (namespace != null) {
            ByteBuffer ns = ByteBuffer.allocate(16);
            ns.putLong(namespace.msb);
            ns.putLong(namespace.lsb);
            hasher.update(ns.array());
        }
        hasher.update(bytes);
        ByteBuffer hash = ByteBuffer.wrap(hasher.digest());
        long msb = hash.getLong();
        long lsb = hash.getLong();
        return GUID.version(msb, lsb, version);
    }

    static MessageDigest hasher(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static GUID version(long hi, long lo, int version) {
        long msb = hi & 0xFFFFFFFFFFFF0FFFL | ((long)version & 0xFL) << 12;
        long lsb = lo & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new GUID(msb, lsb);
    }

    long getMostSignificantBits() {
        return this.msb;
    }

    long getLeastSignificantBits() {
        return this.lsb;
    }

    private static class TLRandom {
        static final long JVM_UNIQUE_NUMBER = new SecureRandom().nextLong();

        private TLRandom() {
        }

        private static long nextLong() {
            return ThreadLocalRandom.current().nextLong() ^ JVM_UNIQUE_NUMBER;
        }
    }

    static final class Parser {
        private static final byte[] MAP;
        private static final int DASH_POSITION_1 = 8;
        private static final int DASH_POSITION_2 = 13;
        private static final int DASH_POSITION_3 = 18;
        private static final int DASH_POSITION_4 = 23;

        Parser() {
        }

        public static GUID parse(String string) {
            int i;
            Parser.validate(string);
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i < 8; ++i) {
                msb = msb << 4 | Parser.get(string, i);
            }
            for (i = 9; i < 13; ++i) {
                msb = msb << 4 | Parser.get(string, i);
            }
            for (i = 14; i < 18; ++i) {
                msb = msb << 4 | Parser.get(string, i);
            }
            for (i = 19; i < 23; ++i) {
                lsb = lsb << 4 | Parser.get(string, i);
            }
            for (i = 24; i < 36; ++i) {
                lsb = lsb << 4 | Parser.get(string, i);
            }
            return new GUID(msb, lsb);
        }

        public static boolean valid(String guid) {
            try {
                Parser.parse(guid);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private static long get(String string, int i) {
            char chr = string.charAt(i);
            if (chr > '\u00ff') {
                throw Parser.exception(string);
            }
            byte value = MAP[chr];
            if (value < 0) {
                throw Parser.exception(string);
            }
            return (long)value & 0xFFL;
        }

        private static RuntimeException exception(String str) {
            return new IllegalArgumentException("Invalid UUID: " + str);
        }

        private static void validate(String string) {
            if (string == null || string.length() != 36) {
                throw Parser.exception(string);
            }
            if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
                throw Parser.exception(string);
            }
        }

        static {
            byte[] mapping = new byte[256];
            Arrays.fill(mapping, (byte)-1);
            mapping[48] = 0;
            mapping[49] = 1;
            mapping[50] = 2;
            mapping[51] = 3;
            mapping[52] = 4;
            mapping[53] = 5;
            mapping[54] = 6;
            mapping[55] = 7;
            mapping[56] = 8;
            mapping[57] = 9;
            mapping[97] = 10;
            mapping[98] = 11;
            mapping[99] = 12;
            mapping[100] = 13;
            mapping[101] = 14;
            mapping[102] = 15;
            mapping[65] = 10;
            mapping[66] = 11;
            mapping[67] = 12;
            mapping[68] = 13;
            mapping[69] = 14;
            mapping[70] = 15;
            MAP = mapping;
        }
    }
}

