/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.Field;
import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.internal.util.LimitedCharArrayIntegerUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;
import java.time.format.DateTimeParseException;

public class ZoneOffsetToken
implements DateTimeToken {
    @Override
    public int read(String text2, ParsePosition parsePosition) {
        int idx = parsePosition.getIndex();
        int len = text2.length();
        int left = len - idx;
        if (left < 1) {
            return -1;
        }
        char c = text2.charAt(idx);
        if (c == 'Z' || c == 'z') {
            parsePosition.setIndex(idx + 1);
            return 0;
        }
        char sign = text2.charAt(idx);
        if (sign != '+' && sign != '-') {
            ErrorUtil.raiseUnexpectedCharacter(text2, idx, 'Z', 'z', '+', '-');
        }
        if (left < 6) {
            throw new DateTimeParseException(String.format("Invalid timezone offset: %s", text2), text2, idx);
        }
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(text2, idx + 1, idx + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(text2, idx + 4, idx + 4 + 2);
        if (sign == '-') {
            hours = -hours;
            minutes = -minutes;
            if (hours == 0 && minutes == 0) {
                throw new DateTimeParseException("Unknown 'Local Offset Convention' date-time not allowed", text2, idx);
            }
        }
        parsePosition.setIndex(idx + 6);
        return hours * 3600 + minutes * 60;
    }

    @Override
    public Field getField() {
        return Field.ZONE_OFFSET;
    }
}

