/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;
import java.time.format.DateTimeParseException;
import java.util.Arrays;

public class SeparatorsToken
implements DateTimeToken {
    private final char[] separators;

    public SeparatorsToken(char ... separators) {
        this.separators = separators;
    }

    @Override
    public int read(String text2, ParsePosition parsePosition) {
        int index = parsePosition.getIndex();
        if (text2.length() <= index) {
            ErrorUtil.raiseUnexpectedEndOfText(text2, text2.length());
        }
        char c = text2.charAt(index);
        for (char sep : this.separators) {
            if (c != sep) continue;
            parsePosition.setIndex(index + 1);
            return 1;
        }
        throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", Arrays.toString(this.separators), index + 1, Character.valueOf(text2.charAt(index)), text2), text2, index);
    }

    public String toString() {
        return "separators: " + Arrays.toString(this.separators);
    }
}

