/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.Expression;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.UriTemplateComponent;
import com.damnhandy.uri.template.UriUtil;
import com.damnhandy.uri.template.VarExploder;
import com.damnhandy.uri.template.VariableExpansionException;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.Operator;
import com.damnhandy.uri.template.impl.UriTemplateParser;
import com.damnhandy.uri.template.impl.VarExploderFactory;
import com.damnhandy.uri.template.impl.VarSpec;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class UriTemplate
implements Serializable {
    private static final long serialVersionUID = -5245084430838445979L;
    public static final String DEFAULT_SEPARATOR = ",";
    transient DateTimeFormatter defaultDateTimeFormatter = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    @Deprecated
    protected DateFormat defaultDateFormat = null;
    private static final char[] OPERATORS = new char[]{'+', '#', '.', '/', ';', '?', '&', '!', '='};
    private static final BitSet OPERATOR_BITSET = new BitSet();
    private String template;
    private Pattern reverseMatchPattern;
    private Map<String, Object> values = new LinkedHashMap<String, Object>();
    private LinkedList<UriTemplateComponent> components;
    private List<Expression> expressions;
    private Set<String> variables;

    private UriTemplate(String template) throws MalformedUriTemplateException {
        this.template = template;
        this.parseTemplateString();
    }

    protected UriTemplate(LinkedList<UriTemplateComponent> components) {
        this.components = components;
        this.initExpressions();
        this.buildTemplateStringFromComponents();
    }

    public static UriTemplateBuilder createBuilder() {
        return new UriTemplateBuilder();
    }

    public static UriTemplateBuilder buildFromTemplate(String template) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(template);
    }

    public static UriTemplateBuilder buildFromTemplate(UriTemplate baseTemplate) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(baseTemplate);
    }

    public static final UriTemplate fromTemplate(String templateString) throws MalformedUriTemplateException {
        return new UriTemplate(templateString);
    }

    @Deprecated
    public static UriTemplateBuilder fromTemplate(UriTemplate baseTemplate) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(baseTemplate);
    }

    public Collection<UriTemplateComponent> getComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    public int expressionCount() {
        return this.expressions.size();
    }

    public Expression[] getExpressions() {
        return this.expressions.toArray(new Expression[this.expressions.size()]);
    }

    public String[] getVariables() {
        if (this.variables == null) {
            this.variables = new LinkedHashSet<String>();
            for (Expression e : this.getExpressions()) {
                for (VarSpec v : e.getVarSpecs()) {
                    this.variables.add(v.getVariableName());
                }
            }
        }
        return this.variables.toArray(new String[this.variables.size()]);
    }

    protected void parseTemplateString() throws MalformedUriTemplateException {
        String templateString = this.getTemplate();
        UriTemplateParser scanner = new UriTemplateParser();
        this.components = scanner.scan(templateString);
        this.initExpressions();
    }

    private void initExpressions() {
        this.expressions = new LinkedList<Expression>();
        for (UriTemplateComponent c : this.components) {
            if (!(c instanceof Expression)) continue;
            this.expressions.add((Expression)c);
        }
    }

    private void buildTemplateStringFromComponents() {
        StringBuilder b = new StringBuilder();
        for (UriTemplateComponent c : this.components) {
            b.append(c.getValue());
        }
        this.template = b.toString();
    }

    private void buildReverseMatchRegexFromComponents() {
        StringBuilder b = new StringBuilder();
        for (UriTemplateComponent c : this.components) {
            b.append("(").append(c.getMatchPattern()).append(")");
        }
        this.reverseMatchPattern = Pattern.compile(b.toString());
    }

    protected Pattern getReverseMatchPattern() {
        if (this.reverseMatchPattern == null) {
            this.buildReverseMatchRegexFromComponents();
        }
        return this.reverseMatchPattern;
    }

    public static String expand(String templateString, Map<String, Object> values2) throws MalformedUriTemplateException, VariableExpansionException {
        UriTemplate t2 = new UriTemplate(templateString);
        t2.set(values2);
        return t2.expand();
    }

    public static String expandPartial(String templateString, Map<String, Object> values2) throws MalformedUriTemplateException, VariableExpansionException {
        UriTemplate t2 = new UriTemplate(templateString);
        t2.set(values2);
        return t2.expandPartial();
    }

    public String expand(Map<String, Object> vars) throws VariableExpansionException {
        this.values = vars;
        return this.expand();
    }

    public String expand() throws VariableExpansionException {
        String template = this.getTemplate();
        for (Expression expression : this.expressions) {
            String replacement = this.expressionReplacementString(expression, false);
            template = template.replaceAll(expression.getReplacementPattern(), replacement);
        }
        return template;
    }

    public String expandPartial() throws VariableExpansionException {
        String template = this.getTemplate();
        for (Expression expression : this.expressions) {
            String replacement = this.expressionReplacementString(expression, true);
            template = template.replaceAll(expression.getReplacementPattern(), replacement);
        }
        return template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public UriTemplate withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(DateTimeFormat.forPattern(dateFormatString));
    }

    private UriTemplate withDefaultDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.defaultDateTimeFormatter = dateTimeFormatter;
        return this;
    }

    @Deprecated
    public UriTemplate withDefaultDateFormat(DateFormat dateFormat) {
        if (!(dateFormat instanceof SimpleDateFormat)) {
            throw new IllegalArgumentException("The only supported subclass of java.text.DateFormat is java.text.SimpleDateFormat");
        }
        this.defaultDateTimeFormatter = DateTimeFormat.forPattern(((SimpleDateFormat)dateFormat).toPattern());
        return this;
    }

    public UriTemplate set(String variableName, Object value) {
        this.values.put(variableName, value);
        return this;
    }

    public boolean hasVariable(String variableName) {
        return this.values.containsKey(variableName);
    }

    public Object get(String variableName) {
        return this.values.get(variableName);
    }

    public UriTemplate set(String variableName, Date value) {
        this.values.put(variableName, value);
        return this;
    }

    public UriTemplate set(Map<String, Object> values2) {
        if (values2 != null && !values2.isEmpty()) {
            this.values.putAll(values2);
        }
        return this;
    }

    public static boolean containsOperator(String op) {
        return OPERATOR_BITSET.get(op.toCharArray()[0]);
    }

    private String expressionReplacementString(Expression expression, boolean partial) throws VariableExpansionException {
        String result2;
        Operator operator = expression.getOperator();
        List<String> replacements = this.expandVariables(expression, partial);
        String string = result2 = partial ? this.joinParts(expression, replacements) : this.joinParts(operator.getSeparator(), replacements);
        if (result2 != null) {
            if (!partial && operator != Operator.RESERVED) {
                result2 = operator.getPrefix() + result2;
            }
        } else {
            result2 = "";
        }
        return result2;
    }

    private List<String> expandVariables(Expression expression, boolean partial) throws VariableExpansionException {
        ArrayList<String> replacements = new ArrayList<String>();
        Operator operator = expression.getOperator();
        for (VarSpec varSpec : expression.getVarSpecs()) {
            if (this.values.containsKey(varSpec.getVariableName())) {
                boolean explodable;
                Object value = this.values.get(varSpec.getVariableName());
                String expanded = null;
                if (value != null && value.getClass().isArray()) {
                    if (value instanceof char[][]) {
                        char[][] chars = (char[][])value;
                        ArrayList<String> strings = new ArrayList<String>();
                        for (char[] c : chars) {
                            strings.add(String.valueOf(c));
                        }
                        value = strings;
                    } else {
                        value = value instanceof char[] ? String.valueOf((char[])value) : this.arrayToList(value);
                    }
                }
                if ((explodable = this.isExplodable(value)) && varSpec.getModifier() == Modifier.PREFIX) {
                    throw new VariableExpansionException("Prefix modifiers are not applicable to variables that have composite values.");
                }
                if (explodable) {
                    VarExploder exploder = value instanceof VarExploder ? (VarExploder)value : VarExploderFactory.getExploder(value, varSpec);
                    if (varSpec.getModifier() == Modifier.EXPLODE) {
                        expanded = this.expandMap(operator, varSpec, exploder.getNameValuePairs());
                    } else if (varSpec.getModifier() != Modifier.EXPLODE) {
                        expanded = this.expandCollection(operator, varSpec, exploder.getValues());
                    }
                }
                if (value instanceof Date) {
                    value = this.defaultDateTimeFormatter.print(new DateTime((Date)value));
                }
                if (value instanceof Collection) {
                    expanded = this.expandCollection(operator, varSpec, (Collection)value);
                } else if (value instanceof Map) {
                    expanded = this.expandMap(operator, varSpec, (Map)value);
                } else if (value == null) {
                    expanded = null;
                } else if (expanded == null) {
                    expanded = this.expandStringValue(operator, varSpec, value.toString(), VarSpec.VarFormat.SINGLE);
                }
                if (expanded == null) continue;
                replacements.add(expanded);
                continue;
            }
            if (!partial) continue;
            replacements.add(null);
        }
        return replacements;
    }

    private boolean isExplodable(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection || value instanceof Map || value.getClass().isArray()) {
            return true;
        }
        return !this.isSimpleType(value);
    }

    private boolean isSimpleType(Object value) {
        return value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof Class || value instanceof Number || value instanceof CharSequence || value instanceof Date || value instanceof Boolean || value instanceof UUID;
    }

    private String expandCollection(Operator operator, VarSpec varSpec, Collection<?> variable) throws VariableExpansionException {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        Iterator<?> i = variable.iterator();
        String separator = operator.getSeparator();
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            separator = operator.getListSeparator();
        }
        while (i.hasNext()) {
            String value;
            Object obj = i.next();
            this.checkValue(obj);
            if (this.checkValue(obj)) {
                value = this.joinParts(DEFAULT_SEPARATOR, obj);
            } else if (this.isSimpleType(obj)) {
                value = obj.toString();
            } else {
                throw new VariableExpansionException("Collections or other complex types are not supported in collections.");
            }
            stringValues.add(this.expandStringValue(operator, varSpec, value, VarSpec.VarFormat.ARRAY));
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && operator.useVarNameWhenExploded()) {
            String parts = this.joinParts(separator, stringValues);
            if (operator == Operator.QUERY && parts == null) {
                return varSpec.getVariableName() + "=";
            }
            return varSpec.getVariableName() + "=" + parts;
        }
        return this.joinParts(separator, stringValues);
    }

    private boolean checkValue(Object obj) throws VariableExpansionException {
        if (obj instanceof Map) {
            throw new VariableExpansionException("Nested data structures are not supported.");
        }
        return obj instanceof Collection || obj.getClass().isArray();
    }

    private String expandMap(Operator operator, VarSpec varSpec, Map<String, Object> variable) throws VariableExpansionException {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        String pairJoiner = "=";
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            pairJoiner = DEFAULT_SEPARATOR;
        }
        String joiner = operator.getSeparator();
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            joiner = operator.getListSeparator();
        }
        for (Map.Entry<String, Object> entry : variable.entrySet()) {
            String value;
            String key = entry.getKey();
            if (this.checkValue(entry.getValue())) {
                value = this.joinParts(DEFAULT_SEPARATOR, entry.getValue());
            } else if (this.isSimpleType(entry.getValue())) {
                value = entry.getValue().toString();
            } else {
                throw new VariableExpansionException("Collections or other complex types are not supported in collections.");
            }
            String pair = this.expandStringValue(operator, varSpec, key, VarSpec.VarFormat.PAIRS) + pairJoiner + this.expandStringValue(operator, varSpec, value, VarSpec.VarFormat.PAIRS);
            stringValues.add(pair);
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && (operator == Operator.MATRIX || operator == Operator.QUERY || operator == Operator.CONTINUATION)) {
            String joinedValues = this.joinParts(joiner, stringValues);
            if (operator == Operator.QUERY && joinedValues == null) {
                return varSpec.getVariableName() + "=";
            }
            return varSpec.getVariableName() + "=" + joinedValues;
        }
        return this.joinParts(joiner, stringValues);
    }

    private String expandStringValue(Operator operator, VarSpec varSpec, String variable, VarSpec.VarFormat format) throws VariableExpansionException {
        String expanded;
        int position;
        if (varSpec.getModifier() == Modifier.PREFIX && (position = varSpec.getPosition().intValue()) < variable.length()) {
            variable = variable.substring(0, position);
        }
        try {
            expanded = operator.getEncoding() == Encoding.UR ? UriUtil.encodeFragment(variable) : UriUtil.encode(variable);
        }
        catch (UnsupportedEncodingException e) {
            throw new VariableExpansionException("Could not expand variable due to a problem URI encoding the value.", e);
        }
        if (operator.isNamed()) {
            if (expanded.isEmpty() && !"&".equals(operator.getSeparator())) {
                expanded = varSpec.getValue();
            } else if (format == VarSpec.VarFormat.SINGLE) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            } else if (varSpec.getModifier() == Modifier.EXPLODE && operator.useVarNameWhenExploded() && format != VarSpec.VarFormat.PAIRS) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            }
        }
        return expanded;
    }

    private String joinParts(String joiner, Object parts) {
        if (parts instanceof Collection) {
            Collection values2 = (Collection)parts;
            ArrayList<String> v = new ArrayList<String>();
            for (String s2 : values2) {
                v.add(s2);
            }
            return this.joinParts(joiner, v);
        }
        if (parts.getClass().isArray()) {
            List<String> v = Arrays.asList((String[])parts);
            return this.joinParts(joiner, v);
        }
        return null;
    }

    private String joinParts(String joiner, List<String> parts) {
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return parts.get(0);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty()) continue;
            builder.append(part);
            if (parts.size() <= 0 || i == parts.size() - 1) continue;
            builder.append(joiner);
        }
        return builder.toString();
    }

    private String joinParts(Expression expression, List<String> parts) {
        int[] index = this.getIndexForPartsWithNullsFirstIfQueryOrRegularSequnceIfNot(expression, parts);
        ArrayList<String> replacedParts = new ArrayList<String>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            StringBuilder builder = new StringBuilder();
            if (parts.get(index[i]) == null) {
                builder.append('{');
                while (i < parts.size() && parts.get(index[i]) == null) {
                    if (builder.length() == 1) {
                        builder.append(replacedParts.size() == 0 ? expression.getOperator().getPrefix() : expression.getOperator().getSeparator());
                    } else {
                        builder.append(DEFAULT_SEPARATOR);
                    }
                    builder.append(expression.getVarSpecs().get(index[i]).getValue());
                    ++i;
                }
                --i;
                builder.append('}');
            } else {
                if (expression.getOperator() != Operator.RESERVED) {
                    builder.append(replacedParts.size() == 0 ? expression.getOperator().getPrefix() : expression.getOperator().getSeparator());
                }
                builder.append(parts.get(index[i]));
            }
            replacedParts.add(builder.toString());
        }
        return this.joinParts("", replacedParts);
    }

    private List<Object> arrayToList(Object array) throws VariableExpansionException {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element.getClass().isArray()) {
                throw new VariableExpansionException("Multi-dimenesional arrays are not supported.");
            }
            list.add(element);
        }
        return list;
    }

    private int[] getIndexForPartsWithNullsFirstIfQueryOrRegularSequnceIfNot(Expression expression, List<String> parts) {
        int[] index = new int[parts.size()];
        int forward = 0;
        int backward = parts.size() - 1;
        for (int i = 0; i < parts.size(); ++i) {
            if (expression.getOperator() == Operator.QUERY) {
                int inverse = parts.size() - i - 1;
                if (parts.get(i) != null) {
                    index[forward++] = i;
                }
                if (parts.get(inverse) != null) continue;
                index[backward--] = inverse;
                continue;
            }
            index[i] = i;
        }
        return index;
    }

    static {
        for (int i = 0; i < OPERATORS.length; ++i) {
            OPERATOR_BITSET.set(OPERATORS[i]);
        }
    }

    public static enum Encoding {
        U,
        UR;

    }
}

