/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Parameterized {
    private Field field;
    private Method method;
    private Method getter;
    private WrappedParameter wrappedParameter;
    private ParametersDelegate parametersDelegate;

    public Parameterized(WrappedParameter wp, ParametersDelegate pd, Field field, Method method) {
        this.wrappedParameter = wp;
        this.method = method;
        this.field = field;
        if (this.field != null) {
            if (pd == null) {
                Parameterized.setFieldAccessible(this.field);
            } else {
                Parameterized.setFieldAccessibleWithoutFinalCheck(this.field);
            }
        }
        this.parametersDelegate = pd;
    }

    private static void describeClassTree(Class<?> inputClass, Set<Class<?>> setOfClasses) {
        if (inputClass == null) {
            return;
        }
        if (Object.class.equals(inputClass) || setOfClasses.contains(inputClass)) {
            return;
        }
        setOfClasses.add(inputClass);
        Parameterized.describeClassTree(inputClass.getSuperclass(), setOfClasses);
        for (Class<?> hasInterface : inputClass.getInterfaces()) {
            Parameterized.describeClassTree(hasInterface, setOfClasses);
        }
    }

    private static Set<Class<?>> describeClassTree(Class<?> inputClass) {
        if (inputClass == null) {
            return Collections.emptySet();
        }
        Set<Class<?>> classes = Sets.newLinkedHashSet();
        Parameterized.describeClassTree(inputClass, classes);
        return classes;
    }

    public static List<Parameterized> parseArg(Object arg) {
        List<Parameterized> result2 = Lists.newArrayList();
        Class<?> rootClass = arg.getClass();
        Set<Class<?>> types = Parameterized.describeClassTree(rootClass);
        for (Class<?> cls : types) {
            DynamicParameter dynamicParameter;
            ParametersDelegate delegateAnnotation;
            Parameter annotation;
            for (Field field : cls.getDeclaredFields()) {
                annotation = field.getAnnotation(Parameter.class);
                delegateAnnotation = field.getAnnotation(ParametersDelegate.class);
                dynamicParameter = field.getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    result2.add(new Parameterized(new WrappedParameter(annotation), null, field, null));
                    continue;
                }
                if (dynamicParameter != null) {
                    result2.add(new Parameterized(new WrappedParameter(dynamicParameter), null, field, null));
                    continue;
                }
                if (delegateAnnotation == null) continue;
                result2.add(new Parameterized(null, delegateAnnotation, field, null));
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                ((Method)accessibleObject).setAccessible(true);
                annotation = ((Method)accessibleObject).getAnnotation(Parameter.class);
                delegateAnnotation = ((Method)accessibleObject).getAnnotation(ParametersDelegate.class);
                dynamicParameter = ((Method)accessibleObject).getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    result2.add(new Parameterized(new WrappedParameter(annotation), null, null, (Method)accessibleObject));
                    continue;
                }
                if (dynamicParameter != null) {
                    result2.add(new Parameterized(new WrappedParameter(dynamicParameter), null, null, (Method)accessibleObject));
                    continue;
                }
                if (delegateAnnotation == null) continue;
                result2.add(new Parameterized(null, delegateAnnotation, null, (Method)accessibleObject));
            }
        }
        return result2;
    }

    public WrappedParameter getWrappedParameter() {
        return this.wrappedParameter;
    }

    public Class<?> getType() {
        if (this.method != null) {
            return this.method.getParameterTypes()[0];
        }
        return this.field.getType();
    }

    public String getName() {
        if (this.method != null) {
            return this.method.getName();
        }
        return this.field.getName();
    }

    public Object get(Object object) {
        try {
            if (this.method != null) {
                if (this.getter == null) {
                    this.setGetter(object);
                }
                return this.getter.invoke(object, new Object[0]);
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ParameterException(e);
        }
        catch (NoSuchMethodException e) {
            String name2 = this.method.getName();
            String fieldName = Character.toLowerCase(name2.charAt(3)) + name2.substring(4);
            Object result2 = null;
            try {
                Field field = this.method.getDeclaringClass().getDeclaredField(fieldName);
                if (field != null) {
                    Parameterized.setFieldAccessible(field);
                    result2 = field.get(object);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            return result2;
        }
    }

    private void setGetter(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (Boolean.class.getSimpleName().toLowerCase().equals(this.getType().getName())) {
            try {
                this.getter = object.getClass().getMethod("is" + this.method.getName().substring(3), new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.getter = object.getClass().getMethod("g" + this.method.getName().substring(1), new Class[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.field == null ? 0 : this.field.hashCode());
        result2 = 31 * result2 + (this.method == null ? 0 : this.method.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameterized other = (Parameterized)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public boolean isDynamicParameter(Field field) {
        if (this.method != null) {
            return this.method.getAnnotation(DynamicParameter.class) != null;
        }
        return this.field.getAnnotation(DynamicParameter.class) != null;
    }

    private static void setFieldAccessible(Field f) {
        if (Modifier.isFinal(f.getModifiers())) {
            throw new ParameterException("Cannot use final field " + f.getDeclaringClass().getName() + "#" + f.getName() + " as a parameter; compile-time constant inlining may hide new values written to it.");
        }
        f.setAccessible(true);
    }

    private static void setFieldAccessibleWithoutFinalCheck(Field f) {
        f.setAccessible(true);
    }

    private static String errorMessage(Method m4, Exception ex) {
        return "Could not invoke " + m4 + "\n    Reason: " + ex.getMessage();
    }

    public void set(Object object, Object value) {
        try {
            if (this.method != null) {
                this.method.invoke(object, value);
            } else {
                this.field.set(object, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new ParameterException(Parameterized.errorMessage(this.method, ex));
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof ParameterException) {
                throw (ParameterException)ex.getTargetException();
            }
            throw new ParameterException(Parameterized.errorMessage(this.method, ex));
        }
    }

    public ParametersDelegate getDelegateAnnotation() {
        return this.parametersDelegate;
    }

    public Type getGenericType() {
        if (this.method != null) {
            return this.method.getGenericParameterTypes()[0];
        }
        return this.field.getGenericType();
    }

    public Parameter getParameter() {
        return this.wrappedParameter.getParameter();
    }

    public Type findFieldGenericType() {
        if (this.method != null) {
            return null;
        }
        if (this.field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)this.field.getGenericType();
            Type cls = p.getActualTypeArguments()[0];
            if (cls instanceof Class) {
                return cls;
            }
            if (cls instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)cls;
                if (wildcardType.getLowerBounds().length > 0) {
                    return wildcardType.getLowerBounds()[0];
                }
                if (wildcardType.getUpperBounds().length > 0) {
                    return wildcardType.getUpperBounds()[0];
                }
            }
        }
        return null;
    }

    public boolean isDynamicParameter() {
        return this.wrappedParameter.getDynamicParameter() != null;
    }
}

