/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.rpc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.rpc.IdentityIntMap;

public final class RemoteExceptionCause
extends Throwable {
    private static final long serialVersionUID = 7849011228540958997L;
    private static final ClassValue<Function<Throwable, Map<String, String>>> fieldGetterValue = new ClassValue<Function<Throwable, Map<String, String>>>(){

        @Override
        protected Function<Throwable, Map<String, String>> computeValue(Class<?> type) {
            int i;
            Field[] fields2 = type.getFields();
            int length = fields2.length;
            int j = 0;
            for (i = 0; i < length; ++i) {
                if ((fields2[i].getModifiers() & 9) != 1) continue;
                fields2[j++] = fields2[i];
            }
            int finalLength = j;
            Field[] finalFields = j < i ? Arrays.copyOf(fields2, j) : fields2;
            if (finalLength == 0) {
                return t2 -> Collections.emptyMap();
            }
            if (finalLength == 1) {
                Field field = finalFields[0];
                return t2 -> {
                    try {
                        return Collections.singletonMap(field.getName(), String.valueOf(field.get(t2)));
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                };
            }
            return t2 -> {
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (Field field : finalFields) {
                    try {
                        map.put(field.getName(), String.valueOf(field.get(t2)));
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return Collections.unmodifiableMap(map);
            };
        }
    };
    private static final StackTraceElement[] EMPTY_STACK = new StackTraceElement[0];
    private final String exceptionClassName;
    private final Map<String, String> fields;
    private transient String toString;
    private static final int ST_NULL = 0;
    private static final int ST_NEW_STRING = 1;
    private static final int ST_NEW_STACK_ELEMENT_V8 = 2;
    private static final int ST_NEW_STACK_ELEMENT_V9 = 3;
    private static final int ST_NEW_EXCEPTION_CAUSE = 4;
    private static final int ST_INT8 = 5;
    private static final int ST_INT16 = 6;
    private static final int ST_INT32 = 7;
    private static final int ST_INT_MINI = 32;
    private static final int ST_BACKREF_FAR = 64;
    private static final int ST_BACKREF_NEAR = 128;
    private static final String[] NO_STRINGS = new String[0];
    private static final RemoteExceptionCause[] NO_REMOTE_EXCEPTION_CAUSES = new RemoteExceptionCause[0];

    RemoteExceptionCause(String msg, RemoteExceptionCause cause, String exceptionClassName, Map<String, String> fields2, boolean cloneFields) {
        super(msg);
        if (cause != null) {
            this.initCause(cause);
        }
        Assert.checkNotNullParam("exceptionClassName", exceptionClassName);
        this.exceptionClassName = exceptionClassName;
        if (cloneFields) {
            Iterator<Map.Entry<String, String>> iterator2 = fields2.entrySet().iterator();
            if (!iterator2.hasNext()) {
                this.fields = Collections.emptyMap();
            } else {
                Map.Entry<String, String> e1 = iterator2.next();
                String name1 = e1.getKey();
                String value1 = e1.getValue();
                if (name1 == null || value1 == null) {
                    throw CommonMessages.msg.cannotContainNullFieldNameOrValue();
                }
                if (!iterator2.hasNext()) {
                    this.fields = Collections.singletonMap(name1, value1);
                } else {
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    map.put(name1, value1);
                    do {
                        Map.Entry<String, String> next = iterator2.next();
                        map.put(next.getKey(), next.getValue());
                    } while (iterator2.hasNext());
                    this.fields = Collections.unmodifiableMap(map);
                }
            }
        } else {
            this.fields = fields2;
        }
    }

    public RemoteExceptionCause(String msg, String exceptionClassName) {
        this(msg, null, exceptionClassName, Collections.emptyMap(), false);
    }

    public RemoteExceptionCause(String msg, RemoteExceptionCause cause, String exceptionClassName) {
        this(msg, cause, exceptionClassName, Collections.emptyMap(), false);
    }

    public RemoteExceptionCause(String msg, String exceptionClassName, Map<String, String> fields2) {
        this(msg, null, exceptionClassName, fields2, true);
    }

    public RemoteExceptionCause(String msg, RemoteExceptionCause cause, String exceptionClassName, Map<String, String> fields2) {
        this(msg, cause, exceptionClassName, fields2, true);
    }

    public static RemoteExceptionCause of(Throwable t2) {
        return RemoteExceptionCause.of(t2, new IdentityHashMap<Throwable, RemoteExceptionCause>());
    }

    private static RemoteExceptionCause of(Throwable t2, IdentityHashMap<Throwable, RemoteExceptionCause> seen) {
        if (t2 == null) {
            return null;
        }
        if (t2 instanceof RemoteExceptionCause) {
            return (RemoteExceptionCause)t2;
        }
        RemoteExceptionCause existing = seen.get(t2);
        if (existing != null) {
            return existing;
        }
        RemoteExceptionCause e = new RemoteExceptionCause(t2.getMessage(), t2.getClass().getName(), fieldGetterValue.get(t2.getClass()).apply(t2));
        e.setStackTrace(t2.getStackTrace());
        seen.put(t2, e);
        Throwable cause = t2.getCause();
        if (cause != null) {
            e.initCause(RemoteExceptionCause.of(cause, seen));
        }
        for (Throwable throwable : t2.getSuppressed()) {
            e.addSuppressed(RemoteExceptionCause.of(throwable, seen));
        }
        return e;
    }

    public Throwable toPlainThrowable() {
        Throwable throwable = new Throwable(this.toString(), this.getCause());
        throwable.setStackTrace(this.getStackTrace());
        for (Throwable s2 : this.getSuppressed()) {
            throwable.addSuppressed(s2);
        }
        return throwable;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getFieldValue(String fieldName) {
        Assert.checkNotNullParam("fieldName", fieldName);
        return this.fields.get(fieldName);
    }

    @Override
    public String toString() {
        String toString2 = this.toString;
        if (toString2 == null) {
            String message = this.getMessage();
            StringBuilder b = new StringBuilder();
            b.append(message == null ? CommonMessages.msg.remoteException(this.exceptionClassName) : CommonMessages.msg.remoteException(this.exceptionClassName, message));
            Iterator<Map.Entry<String, String>> iterator2 = this.fields.entrySet().iterator();
            if (iterator2.hasNext()) {
                b.append("\n\tPublic fields:");
                do {
                    Map.Entry<String, String> entry = iterator2.next();
                    b.append('\n').append('\t').append('\t').append(entry.getKey()).append('=').append(entry.getValue());
                } while (iterator2.hasNext());
            }
            this.toString = b.toString();
            return this.toString;
        }
        return toString2;
    }

    public void writeToStream(DataOutput output) throws IOException {
        Assert.checkNotNullParam("output", output);
        this.writeToStream(output, new IdentityIntMap<Object>(), new HashMap<String, String>(), 0);
    }

    private static int readPackedInt(DataInput is) throws IOException {
        int b = is.readUnsignedByte();
        if ((b & 0xE0) == 32) {
            return b << 27 >> 27;
        }
        if (b == 5) {
            return is.readByte();
        }
        if (b == 6) {
            return is.readShort();
        }
        if (b == 7) {
            return is.readInt();
        }
        throw CommonMessages.msg.corruptedStream();
    }

    private static void writePackedInt(DataOutput os, int val) throws IOException {
        if (-16 <= val && val < 16) {
            os.write(0x20 | val & 0x1F);
        } else if (-128 <= val && val < 128) {
            os.write(5);
            os.write(val);
        } else if (Short.MIN_VALUE <= val && val < 32768) {
            os.write(6);
            os.writeShort(val);
        } else {
            os.write(7);
            os.writeInt(val);
        }
    }

    private int writeToStream(DataOutput output, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        seen.put(this, cnt++);
        output.writeByte(4);
        cnt = this.writeString(output, this.exceptionClassName, seen, stringCache, cnt);
        cnt = this.writeString(output, this.getMessage(), seen, stringCache, cnt);
        cnt = this.writeStackTrace(output, this.getStackTrace(), seen, stringCache, cnt);
        cnt = this.writeFields(output, this.fields, seen, stringCache, cnt);
        cnt = this.writeThrowable(output, this.getCause(), seen, stringCache, cnt);
        Throwable[] suppressed = this.getSuppressed();
        RemoteExceptionCause.writePackedInt(output, suppressed.length);
        for (Throwable t2 : suppressed) {
            cnt = this.writeThrowable(output, t2, seen, stringCache, cnt);
        }
        return cnt;
    }

    private int writeFields(DataOutput output, Map<String, String> fields2, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        RemoteExceptionCause.writePackedInt(output, fields2.size());
        for (Map.Entry<String, String> entry : fields2.entrySet()) {
            cnt = this.writeString(output, entry.getKey(), seen, stringCache, cnt);
            cnt = this.writeString(output, entry.getValue(), seen, stringCache, cnt);
        }
        return cnt;
    }

    private int writeStackTrace(DataOutput output, StackTraceElement[] stackTrace, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        int length = stackTrace.length;
        RemoteExceptionCause.writePackedInt(output, length);
        for (StackTraceElement element : stackTrace) {
            cnt = this.writeStackElement(output, element, seen, stringCache, cnt);
        }
        return cnt;
    }

    private int writeStackElement(DataOutput output, StackTraceElement element, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        int idx = seen.get(element, -1);
        int distance = cnt - idx;
        if (idx == -1 || distance > 16383) {
            output.write(2);
            cnt = this.writeString(output, element.getClassName(), seen, stringCache, cnt);
            cnt = this.writeString(output, element.getMethodName(), seen, stringCache, cnt);
            cnt = this.writeString(output, element.getFileName(), seen, stringCache, cnt);
            RemoteExceptionCause.writePackedInt(output, element.getLineNumber());
            seen.put(element, cnt++);
            return cnt;
        }
        if (distance < 127) {
            output.writeByte(0x80 | distance);
        } else {
            assert (distance <= 16383);
            output.writeByte(0x40 | distance >> 8);
            output.writeByte(distance);
        }
        return cnt;
    }

    private int writeThrowable(DataOutput output, Throwable throwable, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        if (throwable == null) {
            output.write(0);
            return cnt;
        }
        int idx = seen.get(throwable, -1);
        int distance = cnt - idx;
        if (idx == -1 || distance >= 16384) {
            RemoteExceptionCause nested;
            if (throwable instanceof RemoteExceptionCause) {
                nested = (RemoteExceptionCause)throwable;
            } else {
                seen.put(throwable, cnt);
                nested = RemoteExceptionCause.of(throwable);
            }
            return nested.writeToStream(output, seen, stringCache, cnt);
        }
        if (distance < 127) {
            output.writeByte(0x80 | distance);
        } else {
            assert (distance <= 16383);
            output.writeByte(0x40 | distance >> 8);
            output.writeByte(distance);
        }
        return cnt;
    }

    private int writeString(DataOutput output, String string, IdentityIntMap<Object> seen, HashMap<String, String> stringCache, int cnt) throws IOException {
        if (string == null) {
            output.write(0);
            return cnt;
        }
        string = stringCache.computeIfAbsent(string, Function.identity());
        int idx = seen.get(string, -1);
        int distance = cnt - idx;
        if (idx == -1 || distance > 16383) {
            seen.put(string, cnt);
            output.write(1);
            output.writeUTF(string);
            return cnt + 1;
        }
        if (distance < 127) {
            output.writeByte(0x80 | distance);
        } else {
            assert (distance <= 16383);
            output.writeByte(0x40 | distance >> 8);
            output.writeByte(distance);
        }
        return cnt;
    }

    public static RemoteExceptionCause readFromStream(DataInput input) throws IOException {
        return RemoteExceptionCause.readObject(input, RemoteExceptionCause.class, new ArrayList<Object>(), false);
    }

    private static <T> T readObject(DataInput input, Class<T> expect, ArrayList<Object> cache, boolean allowNull) throws IOException {
        int b = input.readUnsignedByte();
        if (b == 0) {
            if (!allowNull) {
                throw CommonMessages.msg.corruptedStream();
            }
            return null;
        }
        if (b == 1) {
            if (expect != String.class) {
                throw CommonMessages.msg.corruptedStream();
            }
            String str = input.readUTF();
            cache.add(str);
            return expect.cast(str);
        }
        if (b == 4) {
            Map<String, String> fields2;
            StackTraceElement[] stackTrace;
            if (expect != RemoteExceptionCause.class) {
                throw CommonMessages.msg.corruptedStream();
            }
            int idx = cache.size();
            cache.add(null);
            String exClassName = RemoteExceptionCause.readObject(input, String.class, cache, false);
            String exMessage = RemoteExceptionCause.readObject(input, String.class, cache, true);
            int length = RemoteExceptionCause.readPackedInt(input);
            if (length == 0) {
                stackTrace = EMPTY_STACK;
            } else {
                stackTrace = new StackTraceElement[length];
                for (int i = 0; i < length; ++i) {
                    stackTrace[i] = RemoteExceptionCause.readObject(input, StackTraceElement.class, cache, false);
                }
            }
            length = RemoteExceptionCause.readPackedInt(input);
            if (length == 0) {
                fields2 = Collections.emptyMap();
            } else if (length == 1) {
                fields2 = Collections.singletonMap(RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, false));
            } else {
                fields2 = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    fields2.put(RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, false));
                }
            }
            RemoteExceptionCause result2 = new RemoteExceptionCause(exMessage, null, exClassName, fields2, false);
            cache.set(idx, result2);
            RemoteExceptionCause causedBy = RemoteExceptionCause.readObject(input, RemoteExceptionCause.class, cache, true);
            result2.initCause(causedBy);
            length = RemoteExceptionCause.readPackedInt(input);
            result2.setStackTrace(stackTrace);
            for (int i = 0; i < length; ++i) {
                result2.addSuppressed(RemoteExceptionCause.readObject(input, RemoteExceptionCause.class, cache, false));
            }
            return expect.cast(result2);
        }
        if (b == 2) {
            if (expect != StackTraceElement.class) {
                throw CommonMessages.msg.corruptedStream();
            }
            StackTraceElement element = new StackTraceElement(RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, true), RemoteExceptionCause.readPackedInt(input));
            cache.add(element);
            return expect.cast(element);
        }
        if (b == 3) {
            if (expect != StackTraceElement.class) {
                throw CommonMessages.msg.corruptedStream();
            }
            RemoteExceptionCause.readObject(input, String.class, cache, true);
            RemoteExceptionCause.readObject(input, String.class, cache, true);
            RemoteExceptionCause.readObject(input, String.class, cache, true);
            StackTraceElement element = new StackTraceElement(RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, false), RemoteExceptionCause.readObject(input, String.class, cache, true), RemoteExceptionCause.readPackedInt(input));
            cache.add(element);
            return expect.cast(element);
        }
        if ((b & 0x80) != 0) {
            int idx = b & 0x7F;
            if (idx > cache.size()) {
                throw CommonMessages.msg.corruptedStream();
            }
            Object obj = cache.get(cache.size() - idx);
            if (expect.isInstance(obj)) {
                return expect.cast(obj);
            }
            throw CommonMessages.msg.corruptedStream();
        }
        if ((b & 0x40) != 0) {
            int b2 = input.readUnsignedByte();
            int idx = (b & 0x3F) << 8 | b2;
            if (idx > cache.size()) {
                throw CommonMessages.msg.corruptedStream();
            }
            Object obj = cache.get(cache.size() - idx);
            if (expect.isInstance(obj)) {
                return expect.cast(obj);
            }
            throw CommonMessages.msg.corruptedStream();
        }
        throw CommonMessages.msg.corruptedStream();
    }

    Object writeReplace() {
        String[] fieldArray;
        RemoteExceptionCause[] suppressed;
        Throwable[] origSuppressed = this.getSuppressed();
        int length = origSuppressed.length;
        if (length == 0) {
            suppressed = NO_REMOTE_EXCEPTION_CAUSES;
        } else {
            suppressed = new RemoteExceptionCause[length];
            for (int i = 0; i < length; ++i) {
                suppressed[i] = RemoteExceptionCause.of(origSuppressed[i]);
            }
        }
        int size = this.fields.size();
        if (size == 0) {
            fieldArray = NO_STRINGS;
        } else {
            fieldArray = new String[size << 1];
            int i = 0;
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                fieldArray[i++] = entry.getKey();
                fieldArray[i++] = entry.getValue();
            }
        }
        return new Serialized(this.getMessage(), this.exceptionClassName, RemoteExceptionCause.of(this.getCause()), suppressed, this.getStackTrace(), fieldArray);
    }

    @Override
    public RemoteExceptionCause getCause() {
        return (RemoteExceptionCause)super.getCause();
    }

    static final class Serialized
    implements Serializable {
        private static final long serialVersionUID = -2201431870774913071L;
        final String m;
        final String cn;
        final RemoteExceptionCause c;
        final RemoteExceptionCause[] s;
        final StackTraceElement[] st;
        final String[] f;

        Serialized(String m4, String cn, RemoteExceptionCause c, RemoteExceptionCause[] s2, StackTraceElement[] st, String[] f) {
            this.m = m4;
            this.cn = cn;
            this.c = c;
            this.s = s2;
            this.st = st;
            this.f = f;
        }

        Object readResolve() {
            Map<String, String> fields2;
            if (this.f == null) {
                fields2 = Collections.emptyMap();
            } else {
                int fl = this.f.length;
                if ((fl & 1) != 0) {
                    throw CommonMessages.msg.invalidOddFields();
                }
                if (fl == 0) {
                    fields2 = Collections.emptyMap();
                } else if (fl == 2) {
                    fields2 = Collections.singletonMap(this.f[0], this.f[1]);
                } else {
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    for (int i = 0; i < fl; i += 2) {
                        map.put(this.f[i], this.f[i + 1]);
                    }
                    fields2 = Collections.unmodifiableMap(map);
                }
            }
            RemoteExceptionCause ex = new RemoteExceptionCause(this.m, this.c, this.cn, fields2, false);
            ex.setStackTrace(this.st);
            RemoteExceptionCause[] suppressed = this.s;
            if (suppressed != null) {
                for (RemoteExceptionCause c : suppressed) {
                    ex.addSuppressed(c);
                }
            }
            return ex;
        }
    }
}

