/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common;

import java.util.Collection;
import java.util.Map;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.annotation.NotNull;

public final class Assert {
    private Assert() {
    }

    @NotNull
    public static <T> T checkNotNullParam(String name2, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked(name2, value);
        return value;
    }

    @NotNull
    public static <T> T checkNotNullParamWithNullPointerException(String name2, T value) throws NullPointerException {
        Assert.checkNotNullParamChecked("name", name2);
        if (value == null) {
            throw CommonMessages.msg.nullParamNPE(name2);
        }
        return value;
    }

    private static <T> void checkNotNullParamChecked(String name2, T value) {
        if (value == null) {
            throw CommonMessages.msg.nullParam(name2);
        }
    }

    @NotNull
    public static <T> T checkNotNullArrayParam(String name2, int index, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (value == null) {
            throw CommonMessages.msg.nullArrayParam(index, name2);
        }
        return value;
    }

    @NotNull
    public static String checkNotEmptyParam(String name2, String value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static CharSequence checkNotEmptyParam(String name2, CharSequence value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length() == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static <E, T extends Collection<E>> T checkNotEmptyParam(String name2, T value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static <K, V, T extends Map<K, V>> T checkNotEmptyParam(String name2, T value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static <T> T[] checkNotEmptyParam(String name2, T[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static boolean[] checkNotEmptyParam(String name2, boolean[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static byte[] checkNotEmptyParam(String name2, byte[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static short[] checkNotEmptyParam(String name2, short[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static int[] checkNotEmptyParam(String name2, int[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static long[] checkNotEmptyParam(String name2, long[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static float[] checkNotEmptyParam(String name2, float[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    @NotNull
    public static double[] checkNotEmptyParam(String name2, double[] value) {
        Assert.checkNotNullParamChecked("name", name2);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw CommonMessages.msg.emptyParam(name2);
        }
        return value;
    }

    public static void checkMinimumParameter(String name2, int min2, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual < min2) {
            throw CommonMessages.msg.paramLessThan(name2, min2);
        }
    }

    public static void checkMinimumParameter(String name2, long min2, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual < min2) {
            throw CommonMessages.msg.paramLessThan(name2, min2);
        }
    }

    public static void checkMinimumParameter(String name2, float min2, float actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual < min2) {
            throw CommonMessages.msg.paramLessThan(name2, min2);
        }
    }

    public static void checkMinimumParameter(String name2, double min2, double actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual < min2) {
            throw CommonMessages.msg.paramLessThan(name2, min2);
        }
    }

    public static void checkMaximumParameter(String name2, int max, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name2, max);
        }
    }

    public static void checkMaximumParameter(String name2, long max, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name2, max);
        }
    }

    public static void checkMaximumParameter(String name2, float max, float actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name2, max);
        }
    }

    public static void checkMaximumParameter(String name2, double max, double actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name2);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name2, max);
        }
    }

    public static void checkArrayBounds(Object[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(byte[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(char[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(long[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int arrayLength, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkMinimumParameter("offs", 0, offs);
        Assert.checkMinimumParameter("len", 0, len);
        if (offs > arrayLength) {
            throw CommonMessages.msg.arrayOffsetGreaterThanLength(offs, arrayLength);
        }
        if (offs + len > arrayLength) {
            throw CommonMessages.msg.arrayOffsetLengthGreaterThanLength(offs, len, arrayLength);
        }
    }

    @NotNull
    public static <T> T assertNotNull(T value) {
        assert (value != null) : CommonMessages.msg.unexpectedNullValue();
        return value;
    }

    @NotNull
    public static <T> T assertHoldsLock(@NotNull T monitor) {
        assert (Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : CommonMessages.msg.expectedLockHold(monitor);
        return monitor;
    }

    @NotNull
    public static <T> T assertNotHoldsLock(@NotNull T monitor) {
        assert (!Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : CommonMessages.msg.expectedLockNotHold(monitor);
        return monitor;
    }

    public static boolean assertTrue(boolean expr) {
        assert (expr) : CommonMessages.msg.expectedBoolean(expr);
        return expr;
    }

    public static boolean assertFalse(boolean expr) {
        assert (!expr) : CommonMessages.msg.expectedBoolean(expr);
        return expr;
    }

    public static IllegalStateException unreachableCode() {
        return CommonMessages.msg.unreachableCode();
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(@NotNull Object obj) {
        Assert.checkNotNullParamChecked("obj", obj);
        return CommonMessages.msg.impossibleSwitchCase(obj);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(int val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(long val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }

    @NotNull
    public static UnsupportedOperationException unsupported() {
        StackTraceElement element = new Throwable().getStackTrace()[1];
        return CommonMessages.msg.unsupported(element.getMethodName(), element.getClassName());
    }
}

