/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLCommentEncoder
extends Encoder {
    static final char HYPHEN_REPLACEMENT = '~';

    XMLCommentEncoder() {
    }

    @Override
    protected int maxEncodedLength(int n) {
        return n;
    }

    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (ch <= '~') {
                if (ch == '-') {
                    if (i + 1 < n) {
                        if (input.charAt(i + 1) != '-') continue;
                        return i;
                    }
                    return i;
                }
                if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                return i;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n && Character.isLowSurrogate(input.charAt(i + 1))) {
                    int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                    if (Unicode.isNonCharacter(cp)) {
                        return i;
                    }
                    ++i;
                    continue;
                }
                return i;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m4 = output.arrayOffset() + output.limit();
        for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            char ch = in[i];
            if (ch <= '~') {
                if (ch == '-') {
                    if (i + 1 < n) {
                        if (in[i + 1] == '-') {
                            if (j + 1 >= m4) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 45;
                            out[j++] = 126;
                            ++i;
                            continue;
                        }
                        if (j >= m4) {
                            return XMLCommentEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 45;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j >= m4) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 126;
                    continue;
                }
                if (ch > ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                    if (j >= m4) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
                if (j >= m4) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (ch < '\ud800') {
                if (j >= m4) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                if (ch > '\u009f' || ch == '\u0085') {
                    out[j++] = ch;
                    continue;
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        int cp = Character.toCodePoint(ch, in[i + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j >= m4) {
                                return XMLCommentEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            ++i;
                            continue;
                        }
                        if (j + 1 >= m4) {
                            return XMLCommentEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = ch;
                        out[j++] = in[++i];
                        continue;
                    }
                    if (j >= m4) {
                        return XMLCommentEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j >= m4) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j >= m4) {
                    return XMLCommentEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (j >= m4) {
                return XMLCommentEncoder.overflow(input, i, output, j);
            }
            out[j++] = ch;
        }
        return XMLCommentEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "XMLCommentEncoder";
    }
}

