/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe.kdf;

import org.jose4j.jwe.kdf.ConcatKeyDerivationFunction;
import org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcatKeyDerivationFunctionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConcatKeyDerivationFunctionFactory.class);
    private static Class<ConcatenationKeyDerivationFunctionWithSha256> customKdfClass;

    ConcatKeyDerivationFunctionFactory() {
    }

    static ConcatenationKeyDerivationFunctionWithSha256 make(String provider) {
        if (customKdfClass != null) {
            try {
                return customKdfClass.newInstance();
            }
            catch (Exception e) {
                log.debug("Unable to create new instance of " + customKdfClass, e);
            }
        }
        return new ConcatKeyDerivationFunction("SHA-256", provider);
    }

    static {
        String name2 = System.getProperty("org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256");
        if (name2 != null) {
            try {
                customKdfClass = Class.forName(name2);
                ConcatenationKeyDerivationFunctionWithSha256 kdf = customKdfClass.newInstance();
                byte[] z = new byte[]{124, -81, 43, 14, -71, -72, -84, 75, 115, 73, -52, -39, 74, -58, 77, -83};
                kdf.kdf(z, 512, new byte[8]);
                log.debug("Using custom ConcatenationKeyDerivationFunctionWithSha256 implementation: " + kdf.getClass());
            }
            catch (Throwable e) {
                customKdfClass = null;
                log.debug("Using jose4j's concatenation key derivation function implementation because of problems with " + name2, e);
            }
        }
    }
}

