/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.text.MessageFormat;
import org.jboss.logging.Logger;

final class Slf4jLogger
extends Logger {
    private static final long serialVersionUID = 8685757928087758380L;
    private final org.slf4j.Logger logger;

    Slf4jLogger(String name2, org.slf4j.Logger logger2) {
        super(name2);
        this.logger = logger2;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        if (level == Logger.Level.TRACE) {
            return this.logger.isTraceEnabled();
        }
        if (level == Logger.Level.DEBUG) {
            return this.logger.isDebugEnabled();
        }
        return this.infoOrHigherEnabled(level);
    }

    private boolean infoOrHigherEnabled(Logger.Level level) {
        if (level == Logger.Level.INFO) {
            return this.logger.isInfoEnabled();
        }
        if (level == Logger.Level.WARN) {
            return this.logger.isWarnEnabled();
        }
        if (level == Logger.Level.ERROR || level == Logger.Level.FATAL) {
            return this.logger.isErrorEnabled();
        }
        return true;
    }

    @Override
    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                String text2;
                String string = text2 = parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters);
                if (level == Logger.Level.INFO) {
                    this.logger.info(text2, thrown);
                } else if (level == Logger.Level.WARN) {
                    this.logger.warn(text2, thrown);
                } else if (level == Logger.Level.ERROR || level == Logger.Level.FATAL) {
                    this.logger.error(text2, thrown);
                } else if (level == Logger.Level.DEBUG) {
                    this.logger.debug(text2, thrown);
                } else if (level == Logger.Level.TRACE) {
                    this.logger.debug(text2, thrown);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                String text2;
                String string = text2 = parameters == null ? String.format(format, new Object[0]) : String.format(format, parameters);
                if (level == Logger.Level.INFO) {
                    this.logger.info(text2, thrown);
                } else if (level == Logger.Level.WARN) {
                    this.logger.warn(text2, thrown);
                } else if (level == Logger.Level.ERROR || level == Logger.Level.FATAL) {
                    this.logger.error(text2, thrown);
                } else if (level == Logger.Level.DEBUG) {
                    this.logger.debug(text2, thrown);
                } else if (level == Logger.Level.TRACE) {
                    this.logger.debug(text2, thrown);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

