/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonPointerEvaluator;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.ReferenceKnot;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.Uri;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

class ReferenceLookup {
    private final LoadingState ls;
    private final SchemaClient schemaClient;

    @Deprecated
    static JSONObject extend(JSONObject additional, JSONObject original) {
        return new JSONObject(ReferenceLookup.extend(OrgJsonUtil.toMap(additional), OrgJsonUtil.toMap(original)));
    }

    static Map<String, Object> extend(Map<String, Object> additional, Map<String, Object> original) {
        if (additional.keySet().isEmpty()) {
            return original;
        }
        if (original.keySet().isEmpty()) {
            return additional;
        }
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.forEach(rawObj::put);
        additional.forEach(rawObj::put);
        return rawObj;
    }

    static JsonObject lookupObjById(JsonValue val, String idAttrVal) {
        return val.ls.getSubschemaRegistry(val).getById(idAttrVal);
    }

    static URI withoutFragment(String fullUri) {
        int hashmarkIdx = fullUri.indexOf(35);
        String rval = hashmarkIdx == -1 ? fullUri : fullUri.substring(0, hashmarkIdx);
        try {
            return new URI(rval);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceLookup(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.schemaClient = ls.config.schemaClient;
    }

    private Map<String, Object> doExtend(Map<String, Object> additional, Map<String, Object> original) {
        if (this.ls.specVersion() == SpecificationVersion.DRAFT_4) {
            return ReferenceLookup.extend(additional, original);
        }
        return original;
    }

    Map<String, Object> withoutRef(JsonObject original) {
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.keySet().stream().filter(name2 -> !"$ref".equals(name2)).forEach(name2 -> rawObj.put((String)name2, original.get((String)name2)));
        return rawObj;
    }

    private Schema.Builder<?> performQueryEvaluation(String mapKey, JsonPointerEvaluator pointerEvaluator) {
        String absolutePointer = ReferenceResolver.resolve(this.ls.id, mapKey).toString();
        if (this.ls.pointerSchemas.containsKey(absolutePointer)) {
            return this.ls.pointerSchemas.get(absolutePointer).initReference(absolutePointer);
        }
        JsonValue referencedRawSchema = pointerEvaluator.query().getQueryResult();
        return this.createReferenceSchema(mapKey, absolutePointer, referencedRawSchema);
    }

    Schema.Builder<?> lookup(String relPointerString, JsonObject ctx) {
        String absPointerString = ReferenceResolver.resolve(this.ls.id, relPointerString).toString();
        if (this.ls.pointerSchemas.containsKey(absPointerString)) {
            return this.ls.pointerSchemas.get(absPointerString).initReference(absPointerString);
        }
        JsonObject rawInternalReferenced = ReferenceLookup.lookupObjById(this.ls.rootSchemaJson, absPointerString);
        if (rawInternalReferenced != null) {
            return this.createReferenceSchema(relPointerString, absPointerString, rawInternalReferenced);
        }
        if (this.isSameDocumentRef(relPointerString)) {
            return this.performQueryEvaluation(relPointerString, JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), relPointerString));
        }
        JsonPointerEvaluator pointer = this.createPointerEvaluator(absPointerString);
        ReferenceKnot knot = new ReferenceKnot();
        ReferenceSchema.Builder refBuilder = knot.initReference(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, knot);
        JsonPointerEvaluator.QueryResult result2 = pointer.query();
        URI resolutionScope = !this.isSameDocumentRef(absPointerString) ? ReferenceLookup.withoutFragment(absPointerString) : this.ls.id;
        JsonObject containingDocument = result2.getContainingDocument();
        SchemaLocation resultLocation = result2.getQueryResult().ls.pointerToCurrentObj;
        SchemaLoader childLoader = this.ls.initNewDocumentLoader().resolutionScope(resolutionScope).pointerToCurrentObj(resultLocation).schemaJson(result2.getQueryResult()).rootSchemaJson(containingDocument).build();
        Object referredSchema = childLoader.load().build();
        refBuilder.schemaLocation(resultLocation);
        knot.resolveWith((Schema)referredSchema);
        return refBuilder;
    }

    private Schema.Builder<?> createReferenceSchema(String relPointerString, String absPointerString, JsonValue rawReferenced) {
        ReferenceKnot knot = new ReferenceKnot();
        ReferenceSchema.Builder refBuilder = knot.initReference(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, knot);
        Object referredSchema = new SchemaLoader(rawReferenced.ls).load().build();
        knot.resolveWith((Schema)referredSchema);
        return refBuilder;
    }

    private JsonObject initJsonObjectById(URI id) {
        JsonObject o = JsonValue.of(this.ls.config.schemasByURI.get(id)).requireObject();
        this.ls.createCopyForNewSchemaJson(id, o, SchemaLocation.parseURI(id.toString()));
        return o;
    }

    private JsonPointerEvaluator createPointerEvaluator(String absPointerString) {
        if (this.isSameDocumentRef(absPointerString)) {
            return JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), absPointerString);
        }
        try {
            Uri uri = Uri.parse(absPointerString);
            if (this.ls.config.schemasByURI.containsKey(uri.asJavaURI())) {
                JsonObject o = this.initJsonObjectById(uri.asJavaURI());
                return JsonPointerEvaluator.forDocument(o, "#");
            }
            if (this.ls.config.schemasByURI.containsKey(uri.toBeQueried)) {
                JsonObject o = this.initJsonObjectById(uri.toBeQueried);
                return JsonPointerEvaluator.forDocument(o, uri.fragment);
            }
        }
        catch (URISyntaxException e) {
            throw this.ls.createSchemaException(e);
        }
        return JsonPointerEvaluator.forURL(this.schemaClient, absPointerString, this.ls);
    }

    private boolean isSameDocumentRef(String ref) {
        return ref.startsWith("#");
    }
}

