/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.ProjectedJsonObject;

class AdjacentSchemaExtractionState {
    private final JsonObject context;
    private final Set<Schema.Builder<?>> extractedSchemas;

    AdjacentSchemaExtractionState(JsonObject context) {
        this(context, new HashSet());
    }

    private AdjacentSchemaExtractionState(JsonObject context, Set<Schema.Builder<?>> extractedSchemas) {
        this.context = context;
        this.extractedSchemas = extractedSchemas;
    }

    AdjacentSchemaExtractionState reduce(ExtractionResult result2) {
        HashSet newExtractedSchemas = new HashSet(this.extractedSchemas.size() + result2.extractedSchemas.size());
        newExtractedSchemas.addAll(this.extractedSchemas);
        newExtractedSchemas.addAll(result2.extractedSchemas);
        ProjectedJsonObject projectedContext = new ProjectedJsonObject(this.context, result2.consumedKeys);
        return new AdjacentSchemaExtractionState(projectedContext, newExtractedSchemas);
    }

    public JsonObject projectedSchemaJson() {
        return this.context;
    }

    public Collection<Schema.Builder<?>> extractedSchemaBuilders() {
        return this.extractedSchemas;
    }
}

