/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.Visitor;

public class ReferenceSchema
extends Schema {
    private Schema referredSchema;
    private final String refValue;
    private Map<String, Object> unprocessedProperties;
    private String title;
    private String description;
    private SchemaLocation schemaLocation;

    public static Builder builder() {
        return new Builder();
    }

    public ReferenceSchema(Builder builder) {
        super(builder);
        this.refValue = Objects.requireNonNull(builder.refValue, "refValue cannot be null");
        this.unprocessedProperties = builder.unprocessedProperties;
    }

    @Override
    public boolean definesProperty(String field) {
        if (this.referredSchema == null) {
            throw new IllegalStateException("referredSchema must be injected before validation");
        }
        return this.referredSchema.definesProperty(field);
    }

    public Schema getReferredSchema() {
        return this.referredSchema;
    }

    public String getReferenceValue() {
        return this.refValue;
    }

    public void setReferredSchema(Schema referredSchema) {
        if (this.referredSchema != null) {
            throw new IllegalStateException("referredSchema can be injected only once");
        }
        this.referredSchema = referredSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ReferenceSchema) {
            ReferenceSchema that = (ReferenceSchema)o;
            return that.canEqual(this) && Objects.equals(this.refValue, that.refValue) && Objects.equals(this.unprocessedProperties, that.unprocessedProperties) && Objects.equals(this.referredSchema, that.referredSchema) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referredSchema, this.refValue, this.unprocessedProperties, this.title, this.description);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceSchema;
    }

    @Override
    void accept(Visitor visitor2) {
        visitor2.visitReferenceSchema(this);
    }

    @Override
    public Map<String, Object> getUnprocessedProperties() {
        return this.unprocessedProperties == null ? super.getUnprocessedProperties() : this.unprocessedProperties;
    }

    @Override
    public String getTitle() {
        return this.title == null ? super.getTitle() : this.title;
    }

    @Override
    public String getDescription() {
        return this.description == null ? super.getDescription() : this.description;
    }

    @Override
    public SchemaLocation getLocation() {
        return this.schemaLocation == null ? super.getLocation() : this.schemaLocation;
    }

    public static class Builder
    extends Schema.Builder<ReferenceSchema> {
        private ReferenceSchema retval;
        private String refValue = "";

        @Override
        public ReferenceSchema build() {
            if (this.retval == null) {
                this.retval = new ReferenceSchema(this);
            }
            return this.retval;
        }

        public Builder refValue(String refValue) {
            this.refValue = refValue;
            return this;
        }

        public Builder unprocessedProperties(Map<String, Object> unprocessedProperties) {
            if (this.retval != null) {
                this.retval.unprocessedProperties = new HashMap<String, Object>(unprocessedProperties);
            }
            super.unprocessedProperties(unprocessedProperties);
            return this;
        }

        public Builder title(String title) {
            if (this.retval != null) {
                this.retval.title = title;
            }
            super.title(title);
            return this;
        }

        public Builder description(String description) {
            if (this.retval != null) {
                this.retval.description = description;
            }
            super.description(description);
            return this;
        }

        public Builder schemaLocation(SchemaLocation location) {
            if (this.retval != null) {
                this.retval.schemaLocation = location;
            }
            super.schemaLocation(location);
            return this;
        }

        public Builder copy() {
            Builder copy = new Builder();
            if (this.retval != null) {
                copy.build().setReferredSchema(this.retval.getReferredSchema());
            }
            return copy;
        }
    }
}

