/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.Visitor;

public class NumberSchema
extends Schema {
    private final boolean requiresNumber;
    private final Number minimum;
    private final Number maximum;
    private final Number multipleOf;
    private final boolean exclusiveMinimum;
    private final boolean exclusiveMaximum;
    private final Number exclusiveMinimumLimit;
    private final Number exclusiveMaximumLimit;
    private final boolean requiresInteger;

    public static Builder builder() {
        return new Builder();
    }

    public NumberSchema() {
        this(NumberSchema.builder());
    }

    public NumberSchema(Builder builder) {
        super(builder);
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.multipleOf = builder.multipleOf;
        this.requiresNumber = builder.requiresNumber;
        this.requiresInteger = builder.requiresInteger;
        this.exclusiveMinimumLimit = builder.exclusiveMinimumLimit;
        this.exclusiveMaximumLimit = builder.exclusiveMaximumLimit;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean requiresInteger() {
        return this.requiresInteger;
    }

    public boolean isRequiresNumber() {
        return this.requiresNumber;
    }

    public Number getExclusiveMinimumLimit() {
        return this.exclusiveMinimumLimit;
    }

    public Number getExclusiveMaximumLimit() {
        return this.exclusiveMaximumLimit;
    }

    @Override
    void accept(Visitor visitor2) {
        visitor2.visitNumberSchema(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NumberSchema) {
            NumberSchema that = (NumberSchema)o;
            return that.canEqual(this) && this.requiresNumber == that.requiresNumber && this.exclusiveMinimum == that.exclusiveMinimum && this.exclusiveMaximum == that.exclusiveMaximum && Objects.equals(this.exclusiveMinimumLimit, that.exclusiveMinimumLimit) && Objects.equals(this.exclusiveMaximumLimit, that.exclusiveMaximumLimit) && this.requiresInteger == that.requiresInteger && Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.multipleOf, that.multipleOf) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.requiresNumber, this.minimum, this.maximum, this.multipleOf, this.exclusiveMinimum, this.exclusiveMaximum, this.exclusiveMinimumLimit, this.exclusiveMaximumLimit, this.requiresInteger);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumberSchema;
    }

    public static class Builder
    extends Schema.Builder<NumberSchema> {
        private Number minimum;
        private Number maximum;
        private Number exclusiveMinimumLimit;
        private Number exclusiveMaximumLimit;
        private Number multipleOf;
        private boolean exclusiveMinimum = false;
        private boolean exclusiveMaximum = false;
        private boolean requiresNumber = true;
        private boolean requiresInteger = false;

        @Override
        public NumberSchema build() {
            return new NumberSchema(this);
        }

        public Builder exclusiveMaximum(boolean exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public Builder exclusiveMinimum(boolean exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public Builder maximum(Number maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder minimum(Number minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder multipleOf(Number multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        public Builder requiresInteger(boolean requiresInteger) {
            this.requiresInteger = requiresInteger;
            return this;
        }

        public Builder requiresNumber(boolean requiresNumber) {
            this.requiresNumber = requiresNumber;
            return this;
        }

        public Builder exclusiveMinimum(Number exclusiveMimimumLimit) {
            this.exclusiveMinimumLimit = exclusiveMimimumLimit;
            return this;
        }

        public Builder exclusiveMaximum(Number exclusiveMaximumLimit) {
            this.exclusiveMaximumLimit = exclusiveMaximumLimit;
            return this;
        }
    }
}

