/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static ThreadFactory createThreadFactory(final String pattern, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong threadEpoch = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                String threadName = pattern.contains("%d") ? String.format(pattern, this.threadEpoch.addAndGet(1L)) : pattern;
                Thread thread2 = new Thread(r, threadName);
                thread2.setDaemon(daemon);
                return thread2;
            }
        };
    }

    public static void shutdownExecutorServiceQuietly(ExecutorService executorService, long timeout, TimeUnit timeUnit) {
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeout, timeUnit)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(timeout, timeUnit)) {
                    log.error("Executor {} did not terminate in time", (Object)executorService);
                }
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

