/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.kafka.common.KafkaException;

public class Sanitizer {
    private static final Pattern MBEAN_PATTERN = Pattern.compile("[\\w-%\\. \t]*");

    public static String sanitize(String name2) {
        try {
            String encoded = URLEncoder.encode(name2, StandardCharsets.UTF_8.name());
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < encoded.length(); ++i) {
                char c = encoded.charAt(i);
                if (c == '*') {
                    builder.append("%2A");
                    continue;
                }
                if (c == '+') {
                    builder.append("%20");
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new KafkaException(e);
        }
    }

    public static String desanitize(String name2) {
        try {
            return URLDecoder.decode(name2, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new KafkaException(e);
        }
    }

    public static String jmxSanitize(String name2) {
        return MBEAN_PATTERN.matcher(name2).matches() ? name2 : ObjectName.quote(name2);
    }
}

