/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;

public class DeleteRecordsRequest
extends AbstractRequest {
    public static final long HIGH_WATERMARK = -1L;
    private final DeleteRecordsRequestData data;

    private DeleteRecordsRequest(DeleteRecordsRequestData data, short version) {
        super(ApiKeys.DELETE_RECORDS, version);
        this.data = data;
    }

    @Override
    public DeleteRecordsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        DeleteRecordsResponseData result2 = new DeleteRecordsResponseData().setThrottleTimeMs(throttleTimeMs);
        short errorCode = Errors.forException(e).code();
        for (DeleteRecordsRequestData.DeleteRecordsTopic topic : this.data.topics()) {
            DeleteRecordsResponseData.DeleteRecordsTopicResult topicResult = new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(topic.name());
            result2.topics().add(topicResult);
            for (DeleteRecordsRequestData.DeleteRecordsPartition partition : topic.partitions()) {
                topicResult.partitions().add(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(partition.partitionIndex()).setErrorCode(errorCode).setLowWatermark(-1L));
            }
        }
        return new DeleteRecordsResponse(result2);
    }

    public static DeleteRecordsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteRecordsRequest(new DeleteRecordsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteRecordsRequest> {
        private final DeleteRecordsRequestData data;

        public Builder(DeleteRecordsRequestData data) {
            super(ApiKeys.DELETE_RECORDS);
            this.data = data;
        }

        @Override
        public DeleteRecordsRequest build(short version) {
            return new DeleteRecordsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

