/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeQuorumResponseData
implements ApiMessage {
    short errorCode;
    String errorMessage;
    List<TopicData> topics;
    NodeCollection nodes;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top level error code."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The top level error code."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The top level error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_2), ""), new Field("nodes", new CompactArrayOf(Node.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public DescribeQuorumResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeQuorumResponseData() {
        this.errorCode = 0;
        this.errorMessage = "";
        this.topics = new ArrayList<TopicData>(0);
        this.nodes = new NodeCollection(0);
    }

    @Override
    public short apiKey() {
        return 55;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        this.errorCode = _readable.readShort();
        if (_version >= 2) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
        } else {
            this.errorMessage = "";
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        AbstractCollection newCollection = new ArrayList<TopicData>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            ((ArrayList)newCollection).add((TopicData)new TopicData(_readable, _version));
        }
        this.topics = newCollection;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field nodes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new NodeCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ImplicitLinkedHashCollection)newCollection).add((Node)new Node(_readable, _version));
            }
            this.nodes = newCollection;
        } else {
            this.nodes = new NodeCollection(0);
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 2) {
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        }
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            TopicData topicsElement = (TopicData)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.nodes.size() + 1);
            for (Node nodesElement : this.nodes) {
                nodesElement.write(_writable, _cache, _version);
            }
        } else if (!this.nodes.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default nodes at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        if (_version >= 2) {
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.nodes.size() + 1));
            for (Node nodesElement : this.nodes) {
                nodesElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeQuorumResponseData)) {
            return false;
        }
        DescribeQuorumResponseData other = (DescribeQuorumResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.nodes == null ? 0 : this.nodes.hashCode());
        return hashCode;
    }

    @Override
    public DescribeQuorumResponseData duplicate() {
        DescribeQuorumResponseData _duplicate = new DescribeQuorumResponseData();
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        NodeCollection newNodes = new NodeCollection(this.nodes.size());
        for (Node _element : this.nodes) {
            newNodes.add(_element.duplicate());
        }
        _duplicate.nodes = newNodes;
        return _duplicate;
    }

    public String toString() {
        return "DescribeQuorumResponseData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", nodes=" + MessageUtil.deepToString(this.nodes.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    public NodeCollection nodes() {
        return this.nodes;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeQuorumResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeQuorumResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeQuorumResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public DescribeQuorumResponseData setNodes(NodeCollection v) {
        this.nodes = v;
        return this;
    }

    public static class ReplicaState
    implements Message {
        int replicaId;
        Uuid replicaDirectoryId;
        long logEndOffset;
        long lastFetchTimestamp;
        long lastCaughtUpTimestamp;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, ""), new Field("log_end_offset", Type.INT64, "The last known log end offset of the follower or -1 if it is unknown"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("replica_id", Type.INT32, ""), new Field("log_end_offset", Type.INT64, "The last known log end offset of the follower or -1 if it is unknown"), new Field("last_fetch_timestamp", Type.INT64, "The last known leader wall clock time time when a follower fetched from the leader. This is reported as -1 both for the current leader or if it is unknown for a voter"), new Field("last_caught_up_timestamp", Type.INT64, "The leader wall clock append time of the offset for which the follower made the most recent fetch request. This is reported as the current time for the leader and -1 if unknown for a voter"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("replica_id", Type.INT32, ""), new Field("replica_directory_id", Type.UUID, ""), new Field("log_end_offset", Type.INT64, "The last known log end offset of the follower or -1 if it is unknown"), new Field("last_fetch_timestamp", Type.INT64, "The last known leader wall clock time time when a follower fetched from the leader. This is reported as -1 both for the current leader or if it is unknown for a voter"), new Field("last_caught_up_timestamp", Type.INT64, "The leader wall clock append time of the offset for which the follower made the most recent fetch request. This is reported as the current time for the leader and -1 if unknown for a voter"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public ReplicaState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ReplicaState() {
            this.replicaId = 0;
            this.replicaDirectoryId = Uuid.ZERO_UUID;
            this.logEndOffset = 0L;
            this.lastFetchTimestamp = -1L;
            this.lastCaughtUpTimestamp = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            this.replicaId = _readable.readInt();
            this.replicaDirectoryId = _version >= 2 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.logEndOffset = _readable.readLong();
            this.lastFetchTimestamp = _version >= 1 ? _readable.readLong() : -1L;
            this.lastCaughtUpTimestamp = _version >= 1 ? _readable.readLong() : -1L;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.replicaId);
            if (_version >= 2) {
                _writable.writeUuid(this.replicaDirectoryId);
            } else if (!this.replicaDirectoryId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default replicaDirectoryId at version " + _version);
            }
            _writable.writeLong(this.logEndOffset);
            if (_version >= 1) {
                _writable.writeLong(this.lastFetchTimestamp);
            }
            if (_version >= 1) {
                _writable.writeLong(this.lastCaughtUpTimestamp);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            if (_version >= 2) {
                _size.addBytes(16);
            }
            _size.addBytes(8);
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaState)) {
                return false;
            }
            ReplicaState other = (ReplicaState)obj;
            if (this.replicaId != other.replicaId) {
                return false;
            }
            if (!this.replicaDirectoryId.equals(other.replicaDirectoryId)) {
                return false;
            }
            if (this.logEndOffset != other.logEndOffset) {
                return false;
            }
            if (this.lastFetchTimestamp != other.lastFetchTimestamp) {
                return false;
            }
            if (this.lastCaughtUpTimestamp != other.lastCaughtUpTimestamp) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.replicaId;
            hashCode = 31 * hashCode + this.replicaDirectoryId.hashCode();
            hashCode = 31 * hashCode + ((int)(this.logEndOffset >> 32) ^ (int)this.logEndOffset);
            hashCode = 31 * hashCode + ((int)(this.lastFetchTimestamp >> 32) ^ (int)this.lastFetchTimestamp);
            hashCode = 31 * hashCode + ((int)(this.lastCaughtUpTimestamp >> 32) ^ (int)this.lastCaughtUpTimestamp);
            return hashCode;
        }

        @Override
        public ReplicaState duplicate() {
            ReplicaState _duplicate = new ReplicaState();
            _duplicate.replicaId = this.replicaId;
            _duplicate.replicaDirectoryId = this.replicaDirectoryId;
            _duplicate.logEndOffset = this.logEndOffset;
            _duplicate.lastFetchTimestamp = this.lastFetchTimestamp;
            _duplicate.lastCaughtUpTimestamp = this.lastCaughtUpTimestamp;
            return _duplicate;
        }

        public String toString() {
            return "ReplicaState(replicaId=" + this.replicaId + ", replicaDirectoryId=" + this.replicaDirectoryId.toString() + ", logEndOffset=" + this.logEndOffset + ", lastFetchTimestamp=" + this.lastFetchTimestamp + ", lastCaughtUpTimestamp=" + this.lastCaughtUpTimestamp + ")";
        }

        public int replicaId() {
            return this.replicaId;
        }

        public Uuid replicaDirectoryId() {
            return this.replicaDirectoryId;
        }

        public long logEndOffset() {
            return this.logEndOffset;
        }

        public long lastFetchTimestamp() {
            return this.lastFetchTimestamp;
        }

        public long lastCaughtUpTimestamp() {
            return this.lastCaughtUpTimestamp;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaState setReplicaId(int v) {
            this.replicaId = v;
            return this;
        }

        public ReplicaState setReplicaDirectoryId(Uuid v) {
            this.replicaDirectoryId = v;
            return this;
        }

        public ReplicaState setLogEndOffset(long v) {
            this.logEndOffset = v;
            return this;
        }

        public ReplicaState setLastFetchTimestamp(long v) {
            this.lastFetchTimestamp = v;
            return this;
        }

        public ReplicaState setLastCaughtUpTimestamp(long v) {
            this.lastCaughtUpTimestamp = v;
            return this;
        }
    }

    public static class NodeCollection
    extends ImplicitLinkedHashMultiCollection<Node> {
        public NodeCollection() {
        }

        public NodeCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public NodeCollection(Iterator<Node> iterator2) {
            super(iterator2);
        }

        @Override
        public Node find(int nodeId) {
            Node _key = new Node();
            _key.setNodeId(nodeId);
            return this.find(_key);
        }

        @Override
        public List<Node> findAll(int nodeId) {
            Node _key = new Node();
            _key.setNodeId(nodeId);
            return this.findAll(_key);
        }

        public NodeCollection duplicate() {
            NodeCollection _duplicate = new NodeCollection(this.size());
            for (Node _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class ListenerCollection
    extends ImplicitLinkedHashMultiCollection<Listener> {
        public ListenerCollection() {
        }

        public ListenerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ListenerCollection(Iterator<Listener> iterator2) {
            super(iterator2);
        }

        @Override
        public Listener find(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.find(_key);
        }

        @Override
        public List<Listener> findAll(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.findAll(_key);
        }

        public ListenerCollection duplicate() {
            ListenerCollection _duplicate = new ListenerCollection(this.size());
            for (Listener _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class Listener
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the endpoint"), new Field("host", Type.COMPACT_STRING, "The hostname"), new Field("port", Type.UINT16, "The port"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public Listener(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Listener() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 2;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Listener");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Listener");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public Listener duplicate() {
            Listener _duplicate = new Listener();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Listener(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Listener setName(String v) {
            this.name = v;
            return this;
        }

        public Listener setHost(String v) {
            this.host = v;
            return this;
        }

        public Listener setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class Node
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int nodeId;
        ListenerCollection listeners;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_2 = new Schema(new Field("node_id", Type.INT32, "The ID of the associated node"), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_2), "The listeners of this controller"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public Node(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Node() {
            this.nodeId = 0;
            this.listeners = new ListenerCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Node");
            }
            this.nodeId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field listeners was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ListenerCollection newCollection = new ListenerCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new Listener(_readable, _version));
            }
            this.listeners = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of Node");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.nodeId);
            _writable.writeUnsignedVarint(this.listeners.size() + 1);
            for (Listener listenersElement : this.listeners) {
                listenersElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Node");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.listeners.size() + 1));
            for (Listener listenersElement : this.listeners) {
                listenersElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            return this.nodeId == other.nodeId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            if (this.nodeId != other.nodeId) {
                return false;
            }
            if (this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.nodeId;
            return hashCode;
        }

        @Override
        public Node duplicate() {
            Node _duplicate = new Node();
            _duplicate.nodeId = this.nodeId;
            ListenerCollection newListeners = new ListenerCollection(this.listeners.size());
            for (Listener _element : this.listeners) {
                newListeners.add(_element.duplicate());
            }
            _duplicate.listeners = newListeners;
            return _duplicate;
        }

        public String toString() {
            return "Node(nodeId=" + this.nodeId + ", listeners=" + MessageUtil.deepToString(this.listeners.iterator()) + ")";
        }

        public int nodeId() {
            return this.nodeId;
        }

        public ListenerCollection listeners() {
            return this.listeners;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Node setNodeId(int v) {
            this.nodeId = v;
            return this;
        }

        public Node setListeners(ListenerCollection v) {
            this.listeners = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        short errorCode;
        String errorMessage;
        int leaderId;
        int leaderEpoch;
        long highWatermark;
        List<ReplicaState> currentVoters;
        List<ReplicaState> observers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, ""), new Field("leader_id", Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", Type.INT32, "The latest known leader epoch"), new Field("high_watermark", Type.INT64, ""), new Field("current_voters", new CompactArrayOf(ReplicaState.SCHEMA_0), ""), new Field("observers", new CompactArrayOf(ReplicaState.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, ""), new Field("leader_id", Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", Type.INT32, "The latest known leader epoch"), new Field("high_watermark", Type.INT64, ""), new Field("current_voters", new CompactArrayOf(ReplicaState.SCHEMA_1), ""), new Field("observers", new CompactArrayOf(ReplicaState.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, ""), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("leader_id", Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", Type.INT32, "The latest known leader epoch"), new Field("high_watermark", Type.INT64, ""), new Field("current_voters", new CompactArrayOf(ReplicaState.SCHEMA_2), ""), new Field("observers", new CompactArrayOf(ReplicaState.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public PartitionData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.errorMessage = "";
            this.leaderId = 0;
            this.leaderEpoch = 0;
            this.highWatermark = 0L;
            this.currentVoters = new ArrayList<ReplicaState>(0);
            this.observers = new ArrayList<ReplicaState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int i;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            if (_version >= 2) {
                int length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString(length);
                }
            } else {
                this.errorMessage = "";
            }
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this.highWatermark = _readable.readLong();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field currentVoters was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ReplicaState> newCollection = new ArrayList<ReplicaState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaState(_readable, _version));
            }
            this.currentVoters = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field observers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaState(_readable, _version));
            }
            this.observers = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (_version >= 2) {
                if (this.errorMessage == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.errorMessage);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeLong(this.highWatermark);
            _writable.writeUnsignedVarint(this.currentVoters.size() + 1);
            _stringBytes = this.currentVoters.iterator();
            while (_stringBytes.hasNext()) {
                ReplicaState currentVotersElement = (ReplicaState)_stringBytes.next();
                currentVotersElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.observers.size() + 1);
            for (ReplicaState observersElement : this.observers) {
                observersElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (_version >= 2) {
                if (this.errorMessage == null) {
                    _size.addBytes(1);
                } else {
                    byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                }
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.currentVoters.size() + 1));
            for (ReplicaState currentVotersElement : this.currentVoters) {
                currentVotersElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1));
            for (ReplicaState observersElement : this.observers) {
                observersElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.highWatermark != other.highWatermark) {
                return false;
            }
            if (this.currentVoters == null ? other.currentVoters != null : !this.currentVoters.equals(other.currentVoters)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.highWatermark >> 32) ^ (int)this.highWatermark);
            hashCode = 31 * hashCode + (this.currentVoters == null ? 0 : this.currentVoters.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.highWatermark = this.highWatermark;
            ArrayList<ReplicaState> newCurrentVoters = new ArrayList<ReplicaState>(this.currentVoters.size());
            for (ReplicaState _element : this.currentVoters) {
                newCurrentVoters.add(_element.duplicate());
            }
            _duplicate.currentVoters = newCurrentVoters;
            ArrayList<ReplicaState> newObservers = new ArrayList<ReplicaState>(this.observers.size());
            for (ReplicaState _element : this.observers) {
                newObservers.add(_element.duplicate());
            }
            _duplicate.observers = newObservers;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", highWatermark=" + this.highWatermark + ", currentVoters=" + MessageUtil.deepToString(this.currentVoters.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public List<ReplicaState> currentVoters() {
            return this.currentVoters;
        }

        public List<ReplicaState> observers() {
            return this.observers;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public PartitionData setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public PartitionData setHighWatermark(long v) {
            this.highWatermark = v;
            return this;
        }

        public PartitionData setCurrentVoters(List<ReplicaState> v) {
            this.currentVoters = v;
            return this;
        }

        public PartitionData setObservers(List<ReplicaState> v) {
            this.observers = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        String topicName;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_1), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_2), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TopicData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicData() {
            this.topicName = "";
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicName = this.topicName;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

