/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class BrokerRegistrationRequestData
implements ApiMessage {
    int brokerId;
    String clusterId;
    Uuid incarnationId;
    ListenerCollection listeners;
    FeatureCollection features;
    String rack;
    boolean isMigratingZkBroker;
    List<Uuid> logDirs;
    long previousBrokerEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("cluster_id", Type.COMPACT_STRING, "The cluster id of the broker process."), new Field("incarnation_id", Type.UUID, "The incarnation id of the broker process."), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The listeners of this broker"), new Field("features", new CompactArrayOf(Feature.SCHEMA_0), "The features on this broker. Note: in v0-v3, features with MinSupportedVersion = 0 are omitted."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker is in."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("cluster_id", Type.COMPACT_STRING, "The cluster id of the broker process."), new Field("incarnation_id", Type.UUID, "The incarnation id of the broker process."), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The listeners of this broker"), new Field("features", new CompactArrayOf(Feature.SCHEMA_0), "The features on this broker. Note: in v0-v3, features with MinSupportedVersion = 0 are omitted."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker is in."), new Field("is_migrating_zk_broker", Type.BOOLEAN, "If the required configurations for ZK migration are present, this value is set to true"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("cluster_id", Type.COMPACT_STRING, "The cluster id of the broker process."), new Field("incarnation_id", Type.UUID, "The incarnation id of the broker process."), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The listeners of this broker"), new Field("features", new CompactArrayOf(Feature.SCHEMA_0), "The features on this broker. Note: in v0-v3, features with MinSupportedVersion = 0 are omitted."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker is in."), new Field("is_migrating_zk_broker", Type.BOOLEAN, "If the required configurations for ZK migration are present, this value is set to true"), new Field("log_dirs", new CompactArrayOf(Type.UUID), "Log directories configured in this broker which are available."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public BrokerRegistrationRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BrokerRegistrationRequestData() {
        this.brokerId = 0;
        this.clusterId = "";
        this.incarnationId = Uuid.ZERO_UUID;
        this.listeners = new ListenerCollection(0);
        this.features = new FeatureCollection(0);
        this.rack = "";
        this.isMigratingZkBroker = false;
        this.logDirs = new ArrayList<Uuid>(0);
        this.previousBrokerEpoch = -1L;
    }

    @Override
    public short apiKey() {
        return 62;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        this.brokerId = _readable.readInt();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterId had invalid length " + length);
        }
        this.clusterId = _readable.readString(length);
        this.incarnationId = _readable.readUuid();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field listeners was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        AbstractCollection newCollection = new ListenerCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            ((ImplicitLinkedHashCollection)newCollection).add(new Listener(_readable, _version));
        }
        this.listeners = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field features was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new FeatureCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            ((ImplicitLinkedHashCollection)newCollection).add(new Feature(_readable, _version));
        }
        this.features = newCollection;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rack = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rack had invalid length " + length);
            }
            this.rack = _readable.readString(length);
        }
        this.isMigratingZkBroker = _version >= 1 ? _readable.readByte() != 0 : false;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field logDirs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ArrayList)newCollection).add(_readable.readUuid());
            }
            this.logDirs = newCollection;
        } else {
            this.logDirs = new ArrayList<Uuid>(0);
        }
        this.previousBrokerEpoch = _version >= 3 ? _readable.readLong() : -1L;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        Object _stringBytes = _cache.getSerializedValue(this.clusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeUuid(this.incarnationId);
        _writable.writeUnsignedVarint(this.listeners.size() + 1);
        _stringBytes = this.listeners.iterator();
        while (_stringBytes.hasNext()) {
            Listener listenersElement = (Listener)_stringBytes.next();
            listenersElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.features.size() + 1);
        for (Feature featuresElement : this.features) {
            featuresElement.write(_writable, _cache, _version);
        }
        if (this.rack == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.rack);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 1) {
            _writable.writeByte(this.isMigratingZkBroker ? (byte)1 : 0);
        } else if (this.isMigratingZkBroker) {
            throw new UnsupportedVersionException("Attempted to write a non-default isMigratingZkBroker at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.logDirs.size() + 1);
            _stringBytes = this.logDirs.iterator();
            while (_stringBytes.hasNext()) {
                Uuid logDirsElement = (Uuid)_stringBytes.next();
                _writable.writeUuid(logDirsElement);
            }
        }
        if (_version >= 3) {
            _writable.writeLong(this.previousBrokerEpoch);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        Object _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.clusterId, (byte[])_stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        _size.addBytes(16);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.listeners.size() + 1));
        _stringBytes = this.listeners.iterator();
        while (_stringBytes.hasNext()) {
            Listener listenersElement = (Listener)_stringBytes.next();
            listenersElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.features.size() + 1));
        for (Feature featuresElement : this.features) {
            featuresElement.addSize(_size, _cache, _version);
        }
        if (this.rack == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'rack' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rack, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        }
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.logDirs.size() + 1));
            _size.addBytes(this.logDirs.size() * 16);
        }
        if (_version >= 3) {
            _size.addBytes(8);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerRegistrationRequestData)) {
            return false;
        }
        BrokerRegistrationRequestData other = (BrokerRegistrationRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (!this.incarnationId.equals(other.incarnationId)) {
            return false;
        }
        if (this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
            return false;
        }
        if (this.isMigratingZkBroker != other.isMigratingZkBroker) {
            return false;
        }
        if (this.logDirs == null ? other.logDirs != null : !this.logDirs.equals(other.logDirs)) {
            return false;
        }
        if (this.previousBrokerEpoch != other.previousBrokerEpoch) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.incarnationId.hashCode();
        hashCode = 31 * hashCode + (this.listeners == null ? 0 : this.listeners.hashCode());
        hashCode = 31 * hashCode + (this.features == null ? 0 : this.features.hashCode());
        hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
        hashCode = 31 * hashCode + (this.isMigratingZkBroker ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.logDirs == null ? 0 : this.logDirs.hashCode());
        hashCode = 31 * hashCode + ((int)(this.previousBrokerEpoch >> 32) ^ (int)this.previousBrokerEpoch);
        return hashCode;
    }

    @Override
    public BrokerRegistrationRequestData duplicate() {
        BrokerRegistrationRequestData _duplicate = new BrokerRegistrationRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.clusterId = this.clusterId;
        _duplicate.incarnationId = this.incarnationId;
        ListenerCollection newListeners = new ListenerCollection(this.listeners.size());
        for (Object _element : this.listeners) {
            newListeners.add(((Listener)_element).duplicate());
        }
        _duplicate.listeners = newListeners;
        FeatureCollection newFeatures = new FeatureCollection(this.features.size());
        for (Feature _element : this.features) {
            newFeatures.add(_element.duplicate());
        }
        _duplicate.features = newFeatures;
        _duplicate.rack = this.rack == null ? null : this.rack;
        _duplicate.isMigratingZkBroker = this.isMigratingZkBroker;
        ArrayList<Uuid> newLogDirs = new ArrayList<Uuid>(this.logDirs.size());
        for (Uuid _element : this.logDirs) {
            newLogDirs.add(_element);
        }
        _duplicate.logDirs = newLogDirs;
        _duplicate.previousBrokerEpoch = this.previousBrokerEpoch;
        return _duplicate;
    }

    public String toString() {
        return "BrokerRegistrationRequestData(brokerId=" + this.brokerId + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", incarnationId=" + this.incarnationId.toString() + ", listeners=" + MessageUtil.deepToString(this.listeners.iterator()) + ", features=" + MessageUtil.deepToString(this.features.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ", isMigratingZkBroker=" + (this.isMigratingZkBroker ? "true" : "false") + ", logDirs=" + MessageUtil.deepToString(this.logDirs.iterator()) + ", previousBrokerEpoch=" + this.previousBrokerEpoch + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public ListenerCollection listeners() {
        return this.listeners;
    }

    public FeatureCollection features() {
        return this.features;
    }

    public String rack() {
        return this.rack;
    }

    public boolean isMigratingZkBroker() {
        return this.isMigratingZkBroker;
    }

    public List<Uuid> logDirs() {
        return this.logDirs;
    }

    public long previousBrokerEpoch() {
        return this.previousBrokerEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerRegistrationRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public BrokerRegistrationRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public BrokerRegistrationRequestData setIncarnationId(Uuid v) {
        this.incarnationId = v;
        return this;
    }

    public BrokerRegistrationRequestData setListeners(ListenerCollection v) {
        this.listeners = v;
        return this;
    }

    public BrokerRegistrationRequestData setFeatures(FeatureCollection v) {
        this.features = v;
        return this;
    }

    public BrokerRegistrationRequestData setRack(String v) {
        this.rack = v;
        return this;
    }

    public BrokerRegistrationRequestData setIsMigratingZkBroker(boolean v) {
        this.isMigratingZkBroker = v;
        return this;
    }

    public BrokerRegistrationRequestData setLogDirs(List<Uuid> v) {
        this.logDirs = v;
        return this;
    }

    public BrokerRegistrationRequestData setPreviousBrokerEpoch(long v) {
        this.previousBrokerEpoch = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("broker_id", Type.INT32, "The broker ID."), new Field("cluster_id", Type.COMPACT_STRING, "The cluster id of the broker process."), new Field("incarnation_id", Type.UUID, "The incarnation id of the broker process."), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The listeners of this broker"), new Field("features", new CompactArrayOf(Feature.SCHEMA_0), "The features on this broker. Note: in v0-v3, features with MinSupportedVersion = 0 are omitted."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker is in."), new Field("is_migrating_zk_broker", Type.BOOLEAN, "If the required configurations for ZK migration are present, this value is set to true"), new Field("log_dirs", new CompactArrayOf(Type.UUID), "Log directories configured in this broker which are available."), new Field("previous_broker_epoch", Type.INT64, "The epoch before a clean shutdown."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class FeatureCollection
    extends ImplicitLinkedHashMultiCollection<Feature> {
        public FeatureCollection() {
        }

        public FeatureCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FeatureCollection(Iterator<Feature> iterator2) {
            super(iterator2);
        }

        @Override
        public Feature find(String name2) {
            Feature _key = new Feature();
            _key.setName(name2);
            return this.find(_key);
        }

        @Override
        public List<Feature> findAll(String name2) {
            Feature _key = new Feature();
            _key.setName(name2);
            return this.findAll(_key);
        }

        public FeatureCollection duplicate() {
            FeatureCollection _duplicate = new FeatureCollection(this.size());
            for (Feature _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class Feature
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public Feature(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Feature() {
            this.name = "";
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Feature");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Feature");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Feature)) {
                return false;
            }
            Feature other = (Feature)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Feature)) {
                return false;
            }
            Feature other = (Feature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public Feature duplicate() {
            Feature _duplicate = new Feature();
            _duplicate.name = this.name;
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "Feature(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Feature setName(String v) {
            this.name = v;
            return this;
        }

        public Feature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public Feature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The feature name."), new Field("min_supported_version", Type.INT16, "The minimum supported feature level."), new Field("max_supported_version", Type.INT16, "The maximum supported feature level."), Field.TaggedFieldsSection.of(new Object[0])))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class ListenerCollection
    extends ImplicitLinkedHashMultiCollection<Listener> {
        public ListenerCollection() {
        }

        public ListenerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ListenerCollection(Iterator<Listener> iterator2) {
            super(iterator2);
        }

        @Override
        public Listener find(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.find(_key);
        }

        @Override
        public List<Listener> findAll(String name2) {
            Listener _key = new Listener();
            _key.setName(name2);
            return this.findAll(_key);
        }

        public ListenerCollection duplicate() {
            ListenerCollection _duplicate = new ListenerCollection(this.size());
            for (Listener _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class Listener
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public Listener(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Listener() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.securityProtocol = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Listener");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Listener");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public Listener duplicate() {
            Listener _duplicate = new Listener();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "Listener(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Listener setName(String v) {
            this.name = v;
            return this;
        }

        public Listener setHost(String v) {
            this.host = v;
            return this;
        }

        public Listener setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        public Listener setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the endpoint."), new Field("host", Type.COMPACT_STRING, "The hostname."), new Field("port", Type.UINT16, "The port."), new Field("security_protocol", Type.INT16, "The security protocol."), Field.TaggedFieldsSection.of(new Object[0])))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

